/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity.codec.v2;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.raft.jraft.entity.EnumOutter;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.entity.LogId;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryDecoder;
import org.apache.ignite3.raft.jraft.util.AsciiStringUtil;
import org.apache.ignite3.raft.jraft.util.Bits;

public final class V2Decoder
implements LogEntryDecoder {
    public static final V2Decoder INSTANCE = new V2Decoder();

    private V2Decoder() {
    }

    @Override
    public LogEntry decode(byte[] content) {
        if (content == null || content.length == 0) {
            return null;
        }
        if (content[0] != -61) {
            return null;
        }
        LogEntry log = new LogEntry();
        this.decode(log, content);
        return log;
    }

    private void decode(LogEntry log, byte[] content) {
        int pos;
        Reader reader = new Reader(content);
        reader.pos = 1;
        int typeNumber = (int)reader.readLong();
        EnumOutter.EntryType type = Objects.requireNonNull(EnumOutter.EntryType.forNumber(typeNumber));
        log.setType(type);
        long index = reader.readLong();
        long term = reader.readLong();
        log.setId(new LogId(index, term));
        long checksum = Bits.getLongLittleEndian(content, reader.pos);
        log.setChecksum(checksum);
        reader.pos = pos = reader.pos + 8;
        long sequenceToken = reader.readLong();
        log.setSequenceToken(sequenceToken);
        long oldSequenceToken = reader.readLong();
        log.setOldSequenceToken(oldSequenceToken);
        pos = reader.pos;
        if (type != EnumOutter.EntryType.ENTRY_TYPE_DATA) {
            reader.pos = pos;
            int peerCount = (int)reader.readLong();
            pos = reader.pos;
            if (peerCount > 0) {
                ArrayList<PeerId> peers = new ArrayList<PeerId>(peerCount);
                pos = V2Decoder.readNodesList(reader, pos, content, peerCount, peers);
                log.setPeers(peers);
            }
            reader.pos = pos;
            int oldPeerCount = (int)reader.readLong();
            pos = reader.pos;
            if (oldPeerCount > 0) {
                ArrayList<PeerId> oldPeers = new ArrayList<PeerId>(oldPeerCount);
                pos = V2Decoder.readNodesList(reader, pos, content, oldPeerCount, oldPeers);
                log.setOldPeers(oldPeers);
            }
            reader.pos = pos;
            int learnersCount = (int)reader.readLong();
            pos = reader.pos;
            if (learnersCount > 0) {
                ArrayList<PeerId> learners = new ArrayList<PeerId>(learnersCount);
                pos = V2Decoder.readNodesList(reader, pos, content, learnersCount, learners);
                log.setLearners(learners);
            }
            reader.pos = pos;
            int oldLearnersCount = (int)reader.readLong();
            pos = reader.pos;
            if (oldLearnersCount > 0) {
                ArrayList<PeerId> oldLearners = new ArrayList<PeerId>(oldLearnersCount);
                pos = V2Decoder.readNodesList(reader, pos, content, oldLearnersCount, oldLearners);
                log.setOldLearners(oldLearners);
            }
        }
        if (type != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION && content.length > pos) {
            int len = content.length - pos;
            ByteBuffer data = ByteBuffer.wrap(content, pos, len).slice();
            log.setData(data);
        }
    }

    private static int readNodesList(Reader reader, int pos, byte[] content, int count, List<PeerId> nodes) {
        for (int i = 0; i < count; ++i) {
            short len = Bits.getShortLittleEndian(content, pos);
            String consistentId = AsciiStringUtil.unsafeDecode(content, pos += 2, len);
            reader.pos = pos += len;
            int idx = (int)reader.readLong();
            int priority = (int)(reader.readLong() - 1L);
            pos = reader.pos;
            nodes.add(new PeerId(consistentId, idx, priority));
        }
        return pos;
    }

    private static class Reader {
        private final byte[] content;
        int pos;

        private Reader(byte[] content) {
            this.content = content;
        }

        long readLong() {
            long val = 0L;
            int shift = 0;
            while (true) {
                byte b = this.content[this.pos];
                ++this.pos;
                val |= ((long)b & 0x7FL) << shift;
                if ((b & 0x80) == 0) {
                    return val;
                }
                shift += 7;
            }
        }
    }
}

