/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.entity.EntryMetaImpl;
import org.apache.ignite3.raft.jraft.entity.RaftOutter;

class EntryMetaSerializer
implements MessageSerializer<RaftOutter.EntryMeta> {
    public static final EntryMetaSerializer INSTANCE = new EntryMetaSerializer();

    private EntryMetaSerializer() {
    }

    @Override
    public boolean writeMessage(RaftOutter.EntryMeta msg, MessageWriter writer) throws MessageMappingException {
        EntryMetaImpl message = (EntryMetaImpl)msg;
        writer.setMessageTypeInfo(RaftMessagesTypeInfos.entryMeta());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)11)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("checksum", message.checksum());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeLong("dataLen", message.dataLen());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeBoolean("hasChecksum", message.hasChecksum());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeCollection("learnersList", message.learnersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeCollection("oldLearnersList", message.oldLearnersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeCollection("oldPeersList", message.oldPeersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeCollection("peersList", message.peersList(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeLong("term", message.term());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                int idShifted = message.type() == null ? 0 : message.type().id() + 1;
                boolean written = writer.writeInt("type", idShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                boolean written = writer.writeLong("oldSequenceToken", message.oldSequenceToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                boolean written = writer.writeLong("sequenceToken", message.sequenceToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

