/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public final class StringUtils {
    private static final int MASK = 15;
    private static final Pattern NUMERIC = Pattern.compile("[^0-9]");

    public static boolean nullOrEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static boolean nullOrBlank(@Nullable String s) {
        return s == null || s.isBlank();
    }

    public static String incrementLastChar(String s) {
        Objects.requireNonNull(s);
        char[] chars = s.toCharArray();
        char lastChar = chars[chars.length - 1];
        if (lastChar == '\uffff') {
            throw new IllegalArgumentException("Cannot increment the last character as it is equal to MAX_VALUE");
        }
        chars[chars.length - 1] = (char)(lastChar + '\u0001');
        return String.valueOf(chars);
    }

    public static String toHexString(byte[] arr) {
        return StringUtils.toHexString(arr, Integer.MAX_VALUE);
    }

    public static String toHexString(byte[] arr, int maxLen) {
        assert (maxLen >= 0) : "maxLem must be not negative.";
        int capacity = Math.min(arr.length << 1, maxLen);
        int lim = capacity >> 1;
        StringBuilder sb = new StringBuilder(capacity);
        for (int i = 0; i < lim; ++i) {
            StringUtils.addByteAsHex(sb, arr[i]);
        }
        return sb.toString().toUpperCase();
    }

    public static String toHexString(long addr, int len) {
        StringBuilder sb = new StringBuilder(len * 2);
        for (int i = 0; i < len; ++i) {
            StringUtils.addByteAsHex(sb, GridUnsafe.getByte(addr + (long)i));
        }
        return sb.toString();
    }

    public static String toHexString(ByteBuffer buf) {
        StringBuilder sb = new StringBuilder(buf.capacity() * 2);
        for (int i = buf.position(); i < buf.limit(); ++i) {
            StringUtils.addByteAsHex(sb, buf.get(i));
        }
        return sb.toString();
    }

    public static byte[] fromHexString(String s) {
        int len = s.length();
        assert ((len & 1) == 0) : "length should be even";
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private static void addByteAsHex(StringBuilder sb, byte b) {
        sb.append(Integer.toHexString(0xF & b >>> 4)).append(Integer.toHexString(0xF & b));
    }

    public static String hexLong(long val) {
        return new IgniteStringBuilder(16).appendHex(val).toString();
    }

    public static String hexInt(int val) {
        return new IgniteStringBuilder(8).appendHex(val).toString();
    }

    public static String toStringWithoutPrefix(byte[] bytes, int prefixLength) {
        assert (prefixLength > 0) : "prefixLength must be greater than zero: " + prefixLength;
        return new String(bytes, prefixLength, bytes.length - prefixLength, StandardCharsets.UTF_8);
    }

    public static String escapeQuotes(String s) {
        return s.replace("\"", "\\\"");
    }

    public static long parseStorageStringSize(String str, Supplier<Long> upperBound) {
        str = str.toLowerCase(Locale.ROOT);
        long numeric = Long.parseLong(NUMERIC.matcher(str).replaceAll(""));
        if (str.endsWith("k")) {
            return Math.multiplyExact(numeric, 1024);
        }
        if (str.endsWith("m")) {
            return Math.multiplyExact(numeric, 0x100000);
        }
        if (str.endsWith("g")) {
            return Math.multiplyExact(numeric, 0x40000000);
        }
        if (str.endsWith("%")) {
            return (long)((double)numeric / 100.0 * (double)upperBound.get().longValue());
        }
        throw new IllegalArgumentException("Wrong format of incoming string. It is expected to be a number followed by one of the symbols: 'k', 'm', 'g', '%'.\n For example: '10k', '33m', '2G', '35%'. But was: " + str);
    }
}

