/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite3.internal.tx.message.TxStateMetaMessage;
import org.apache.ignite3.internal.tx.message.TxStateMetaMessageBuilder;

class TxStateMetaMessageDeserializer
implements MessageDeserializer<TxStateMetaMessage> {
    private final TxStateMetaMessageBuilder msg;

    TxStateMetaMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txStateMetaMessage();
    }

    @Override
    public Class<TxStateMetaMessage> klass() {
        return TxStateMetaMessage.class;
    }

    @Override
    public TxStateMetaMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.txStateMetaMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readBoxedLong("cleanupCompletionTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.cleanupCompletionTimestamp((Long)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ZonePartitionIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitPartitionId((ZonePartitionIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitTimestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readBoxedLong("initialVacuumObservationTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initialVacuumObservationTimestamp((Long)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readBoxedBoolean("isFinishedDueToTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.isFinishedDueToTimeout((Boolean)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txCoordinatorId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                TxState tmp;
                int shiftedId = reader.readInt("txState");
                if (!reader.isLastRead()) {
                    return false;
                }
                TxState txState = tmp = shiftedId == 0 ? null : TxState.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.txState(tmp);
                }
                reader.incrementState();
            }
            case 7: {
                String tmp = reader.readString("txLabel");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txLabel(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxStateMetaMessage.class);
    }
}

