/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite3.internal.tx.message.TxStateCoordinatorRequest;
import org.apache.ignite3.internal.tx.message.TxStateCoordinatorRequestImpl;

class TxStateCoordinatorRequestSerializer
implements MessageSerializer<TxStateCoordinatorRequest> {
    public static final TxStateCoordinatorRequestSerializer INSTANCE = new TxStateCoordinatorRequestSerializer();

    private TxStateCoordinatorRequestSerializer() {
    }

    @Override
    public boolean writeMessage(TxStateCoordinatorRequest msg, MessageWriter writer) throws MessageMappingException {
        TxStateCoordinatorRequestImpl message = (TxStateCoordinatorRequestImpl)msg;
        writer.setMessageTypeInfo(TxMessagesTypeInfos.txStateCoordinatorRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeHybridTimestamp("readTimestamp", message.readTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeUuid("txId", message.txId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeBoxedLong("senderCurrentConsistencyToken", message.senderCurrentConsistencyToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeMessage("senderGroupId", message.senderGroupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

