/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.message.TxStateCoordinatorRequest;
import org.apache.ignite3.internal.tx.message.TxStateCoordinatorRequestBuilder;
import org.apache.ignite3.internal.tx.message.TxStateCoordinatorRequestSerializer;

public class TxStateCoordinatorRequestImpl
implements TxStateCoordinatorRequest,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 4;
    @IgniteToStringInclude
    private final HybridTimestamp readTimestamp;
    @IgniteToStringInclude
    private final UUID txId;
    @IgniteToStringInclude
    private final Long senderCurrentConsistencyToken;
    @IgniteToStringInclude
    private final ZonePartitionIdMessage senderGroupId;

    private TxStateCoordinatorRequestImpl(HybridTimestamp readTimestamp, UUID txId, Long senderCurrentConsistencyToken, ZonePartitionIdMessage senderGroupId) {
        this.readTimestamp = readTimestamp;
        this.txId = txId;
        this.senderCurrentConsistencyToken = senderCurrentConsistencyToken;
        this.senderGroupId = senderGroupId;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return this.readTimestamp;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    @Override
    public Long senderCurrentConsistencyToken() {
        return this.senderCurrentConsistencyToken;
    }

    @Override
    public ZonePartitionIdMessage senderGroupId() {
        return this.senderGroupId;
    }

    public MessageSerializer serializer() {
        return TxStateCoordinatorRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxStateCoordinatorRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 4;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxStateCoordinatorRequestImpl otherMessage = (TxStateCoordinatorRequestImpl)other;
        return Objects.equals(this.readTimestamp, otherMessage.readTimestamp) && Objects.equals(this.txId, otherMessage.txId) && Objects.equals(this.senderCurrentConsistencyToken, otherMessage.senderCurrentConsistencyToken) && Objects.equals(this.senderGroupId, otherMessage.senderGroupId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.readTimestamp, this.txId, this.senderCurrentConsistencyToken, this.senderGroupId);
        return result;
    }

    @Override
    public TxStateCoordinatorRequestImpl clone() {
        try {
            return (TxStateCoordinatorRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxStateCoordinatorRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.senderGroupId != null) {
            this.senderGroupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.senderGroupId != null) {
            this.senderGroupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements TxStateCoordinatorRequestBuilder {
        private HybridTimestamp readTimestamp;
        private UUID txId;
        private Long senderCurrentConsistencyToken;
        private ZonePartitionIdMessage senderGroupId;

        private Builder() {
        }

        @Override
        public TxStateCoordinatorRequestBuilder readTimestamp(HybridTimestamp readTimestamp) {
            Objects.requireNonNull(readTimestamp, "readTimestamp is not marked @Nullable");
            this.readTimestamp = readTimestamp;
            return this;
        }

        @Override
        public TxStateCoordinatorRequestBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public TxStateCoordinatorRequestBuilder senderCurrentConsistencyToken(Long senderCurrentConsistencyToken) {
            this.senderCurrentConsistencyToken = senderCurrentConsistencyToken;
            return this;
        }

        @Override
        public TxStateCoordinatorRequestBuilder senderGroupId(ZonePartitionIdMessage senderGroupId) {
            this.senderGroupId = senderGroupId;
            return this;
        }

        @Override
        public HybridTimestamp readTimestamp() {
            return this.readTimestamp;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public Long senderCurrentConsistencyToken() {
            return this.senderCurrentConsistencyToken;
        }

        @Override
        public ZonePartitionIdMessage senderGroupId() {
            return this.senderGroupId;
        }

        @Override
        public TxStateCoordinatorRequest build() {
            return new TxStateCoordinatorRequestImpl(Objects.requireNonNull(this.readTimestamp, "readTimestamp is not marked @Nullable"), Objects.requireNonNull(this.txId, "txId is not marked @Nullable"), this.senderCurrentConsistencyToken, this.senderGroupId);
        }

        @Override
        public TxStateCoordinatorRequest buildDeserialized() {
            return new TxStateCoordinatorRequestImpl(this.readTimestamp, this.txId, this.senderCurrentConsistencyToken, this.senderGroupId);
        }
    }
}

