/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.Set;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.tx.message.PartitionEnlistmentMessage;
import org.apache.ignite3.internal.tx.message.PartitionEnlistmentMessageBuilder;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;

class PartitionEnlistmentMessageDeserializer
implements MessageDeserializer<PartitionEnlistmentMessage> {
    private final PartitionEnlistmentMessageBuilder msg;

    PartitionEnlistmentMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.partitionEnlistmentMessage();
    }

    @Override
    public Class<PartitionEnlistmentMessage> klass() {
        return PartitionEnlistmentMessage.class;
    }

    @Override
    public PartitionEnlistmentMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.partitionEnlistmentMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                String tmp = reader.readString("primaryConsistentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.primaryConsistentId(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                String tmp = reader.readSet("tableIds", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.tableIds((Set<Integer>)((Object)tmp));
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(PartitionEnlistmentMessage.class);
    }
}

