/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.Set;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessageBuilder;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessageSerializer;

public class EnlistedPartitionGroupMessageImpl
implements EnlistedPartitionGroupMessage,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 20;
    @IgniteToStringInclude
    private final ZonePartitionIdMessage groupId;
    @IgniteToStringInclude
    private final Set<Integer> tableIds;

    private EnlistedPartitionGroupMessageImpl(ZonePartitionIdMessage groupId, Set<Integer> tableIds) {
        this.groupId = groupId;
        this.tableIds = tableIds;
    }

    @Override
    public ZonePartitionIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public Set<Integer> tableIds() {
        return this.tableIds;
    }

    public MessageSerializer serializer() {
        return EnlistedPartitionGroupMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(EnlistedPartitionGroupMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 20;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        EnlistedPartitionGroupMessageImpl otherMessage = (EnlistedPartitionGroupMessageImpl)other;
        return Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.tableIds, otherMessage.tableIds);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.groupId, this.tableIds);
        return result;
    }

    @Override
    public EnlistedPartitionGroupMessageImpl clone() {
        try {
            return (EnlistedPartitionGroupMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static EnlistedPartitionGroupMessageBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements EnlistedPartitionGroupMessageBuilder {
        private ZonePartitionIdMessage groupId;
        private Set<Integer> tableIds;

        private Builder() {
        }

        @Override
        public EnlistedPartitionGroupMessageBuilder groupId(ZonePartitionIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public EnlistedPartitionGroupMessageBuilder tableIds(Set<Integer> tableIds) {
            Objects.requireNonNull(tableIds, "tableIds is not marked @Nullable");
            this.tableIds = tableIds;
            return this;
        }

        @Override
        public ZonePartitionIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public Set<Integer> tableIds() {
            return this.tableIds;
        }

        @Override
        public EnlistedPartitionGroupMessage build() {
            return new EnlistedPartitionGroupMessageImpl(Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.tableIds, "tableIds is not marked @Nullable"));
        }

        @Override
        public EnlistedPartitionGroupMessage buildDeserialized() {
            return new EnlistedPartitionGroupMessageImpl(this.groupId, this.tableIds);
        }
    }
}

