/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.TxStateMeta;
import org.apache.ignite3.internal.tx.impl.PersistentTxStateVacuumizer;
import org.apache.ignite3.internal.tx.metrics.ResourceVacuumMetrics;
import org.jetbrains.annotations.Nullable;

public class VolatileTxStateMetaStorage {
    private ConcurrentHashMap<UUID, TxStateMeta> txStateMap;

    public void start() {
        this.txStateMap = new ConcurrentHashMap();
    }

    public void stop() {
        this.txStateMap.clear();
    }

    public void initialize(InternalTransaction tx, @Nullable String txLabel) {
        TxStateMeta previous = this.txStateMap.put(tx.id(), TxStateMeta.builder(TxState.PENDING).txCoordinatorId(tx.coordinatorId()).tx(tx).txLabel(txLabel).build());
        assert (previous == null) : "Transaction state has already defined [txId=" + tx.id() + ", state=" + previous.txState() + "]";
    }

    @Nullable
    public <T extends TxStateMeta> T updateMeta(UUID txId, Function<@Nullable TxStateMeta, TxStateMeta> updater) {
        return (T)this.txStateMap.compute(txId, (k, oldMeta) -> {
            TxStateMeta newMeta = (TxStateMeta)updater.apply((TxStateMeta)oldMeta);
            if (newMeta == null) {
                return null;
            }
            TxState oldState = oldMeta == null ? null : oldMeta.txState();
            return TxState.checkTransitionCorrectness(oldState, newMeta.txState()) ? newMeta : oldMeta;
        });
    }

    public TxStateMeta state(UUID txId) {
        return this.txStateMap.get(txId);
    }

    public Collection<TxStateMeta> states() {
        return this.txStateMap.values();
    }

    public CompletableFuture<Void> vacuum(long vacuumObservationTimestamp, long txnResourceTtl, Function<Map<ZonePartitionId, Set<PersistentTxStateVacuumizer.VacuumizableTx>>, CompletableFuture<PersistentTxStateVacuumizer.PersistentTxStateVacuumResult>> persistentVacuumOp, ResourceVacuumMetrics resourceVacuumMetrics) {
        HashMap txIds = new HashMap();
        HashMap cleanupCompletionTimestamps = new HashMap();
        AtomicInteger skippedForFurtherProcessingUnfinishedTxnsCount = new AtomicInteger();
        this.txStateMap.forEach((txId, meta) -> this.txStateMap.computeIfPresent((UUID)txId, (txId0, meta0) -> {
            if (meta0.tx() != null && meta0.tx().isReadOnly()) {
                if (meta0.tx().isFinishingOrFinished()) {
                    resourceVacuumMetrics.onVolatileStateVacuum();
                    return null;
                }
            } else if (TxState.isFinalState(meta0.txState())) {
                Long cleanupCompletionTimestamp;
                Long initialVacuumObservationTimestamp = meta0.initialVacuumObservationTimestamp();
                boolean shouldBeVacuumized = VolatileTxStateMetaStorage.shouldBeVacuumized(initialVacuumObservationTimestamp, cleanupCompletionTimestamp = meta0.cleanupCompletionTimestamp(), txnResourceTtl, vacuumObservationTimestamp);
                if (shouldBeVacuumized) {
                    if (meta0.commitPartitionId() == null) {
                        resourceVacuumMetrics.onVolatileStateVacuum();
                        return null;
                    }
                    Set ids = txIds.computeIfAbsent(meta0.commitPartitionId(), k -> new HashSet());
                    ids.add(new PersistentTxStateVacuumizer.VacuumizableTx((UUID)txId, cleanupCompletionTimestamp));
                    if (cleanupCompletionTimestamp != null) {
                        cleanupCompletionTimestamps.put(txId, cleanupCompletionTimestamp);
                    }
                    return meta0;
                }
                resourceVacuumMetrics.onMarkedForVacuum();
                return meta0;
            }
            skippedForFurtherProcessingUnfinishedTxnsCount.incrementAndGet();
            return meta0;
        }));
        return persistentVacuumOp.apply(txIds).thenAccept(vacuumResult -> {
            for (UUID txId : vacuumResult.txnsToVacuum) {
                this.txStateMap.compute(txId, (k, v) -> {
                    TxStateMeta newMeta;
                    if (v == null) {
                        return null;
                    }
                    Long cleanupCompletionTs = (Long)cleanupCompletionTimestamps.get(txId);
                    TxStateMeta txStateMeta = newMeta = Objects.equals(cleanupCompletionTs, v.cleanupCompletionTimestamp()) ? null : v;
                    if (newMeta == null) {
                        resourceVacuumMetrics.onVolatileStateVacuum();
                    }
                    return newMeta;
                });
            }
            resourceVacuumMetrics.onVacuumFinish(vacuumResult.vacuumizedPersistentTxnStatesCount, skippedForFurtherProcessingUnfinishedTxnsCount.get());
        });
    }

    Map<UUID, TxStateMeta> statesMap() {
        return Collections.unmodifiableMap(this.txStateMap);
    }

    private static boolean shouldBeVacuumized(Long initialVacuumObservationTimestamp, @Nullable Long cleanupCompletionTimestamp, long txnResourceTtl, long vacuumObservationTimestamp) {
        if (txnResourceTtl == 0L) {
            return true;
        }
        assert (initialVacuumObservationTimestamp != null) : "initialVacuumObservationTimestamp should have been set if txnResourceTtl > 0 [txnResourceTtl=" + txnResourceTtl + "].";
        if (cleanupCompletionTimestamp == null) {
            return initialVacuumObservationTimestamp + txnResourceTtl < vacuumObservationTimestamp;
        }
        return cleanupCompletionTimestamp + txnResourceTtl < vacuumObservationTimestamp;
    }
}

