/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.InternalTxOptions;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.tx.TxPriority;
import org.apache.ignite3.tx.IgniteTransactions;
import org.apache.ignite3.tx.Transaction;
import org.apache.ignite3.tx.TransactionOptions;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IgniteTransactionsImpl
implements IgniteTransactions {
    private final TxManager txManager;
    private final HybridTimestampTracker observableTimestampTracker;
    private final LicenseFeatureChecker licenseFeatureChecker;

    public IgniteTransactionsImpl(TxManager txManager, HybridTimestampTracker observableTimestampTracker, LicenseFeatureChecker licenseFeatureChecker) {
        this.txManager = txManager;
        this.observableTimestampTracker = observableTimestampTracker;
        this.licenseFeatureChecker = licenseFeatureChecker;
    }

    @Override
    public Transaction begin(@Nullable TransactionOptions options) {
        InternalTxOptions internalTxOptions;
        this.licenseFeatureChecker.checkFeature(LicenseFeature.EXPLICIT_TRANSACTIONS);
        InternalTxOptions internalTxOptions2 = internalTxOptions = options == null ? InternalTxOptions.defaults() : InternalTxOptions.builder().timeoutMillis(options.timeoutMillis()).build();
        return options != null && options.cacheOnly() ? this.txManager.beginExternal(this.observableTimestampTracker, false) : this.txManager.beginExplicit(this.observableTimestampTracker, options != null && options.readOnly(), internalTxOptions);
    }

    @Override
    public CompletableFuture<Transaction> beginAsync(@Nullable TransactionOptions options) {
        return CompletableFuture.completedFuture(this.begin(options));
    }

    public InternalTransaction beginImplicit(boolean readOnly) {
        return this.txManager.beginImplicit(this.observableTimestampTracker, readOnly, null);
    }

    @TestOnly
    public Transaction beginWithPriority(boolean readOnly, TxPriority priority) {
        return this.txManager.beginExplicit(this.observableTimestampTracker, readOnly, InternalTxOptions.defaultsWithPriority(priority));
    }
}

