/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.tx.TxMeta;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.impl.EnlistedPartitionGroup;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerializer;

public class TxMetaSerializer
extends VersionedSerializer<TxMeta> {
    public static final TxMetaSerializer INSTANCE = new TxMetaSerializer();

    @Override
    protected byte getProtocolVersion() {
        return 2;
    }

    @Override
    protected void writeExternalData(TxMeta meta, IgniteDataOutput out) throws IOException {
        boolean hasAnyZonePartitionIds = true;
        out.writeBoolean(hasAnyZonePartitionIds);
        out.writeVarInt(meta.txState().id());
        out.writeVarInt(meta.enlistedPartitions().size());
        for (EnlistedPartitionGroup enlistedPartitionGroup : meta.enlistedPartitions()) {
            ZonePartitionId partitionGroupId = enlistedPartitionGroup.groupId();
            out.writeVarInt(partitionGroupId.objectId());
            out.writeVarInt(partitionGroupId.partitionId());
            TxMetaSerializer.writeVarIntSet(enlistedPartitionGroup.tableIds(), out);
        }
        HybridTimestamp.write(meta.commitTimestamp(), out);
    }

    @Override
    protected TxMeta readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        if (protoVer == 1) {
            throw new IllegalArgumentException("Transaction meta v1 is not supported.");
        }
        if (protoVer >= 2) {
            boolean usesZonePartitionIds = in.readBoolean();
            assert (usesZonePartitionIds) : "Transaction meta cannot be deserialized. V1 is not supported anymore.";
        }
        TxState state = TxState.fromId(in.readVarIntAsInt());
        List<EnlistedPartitionGroup> enlistedPartitions = TxMetaSerializer.readEnlistedPartitions(in, protoVer);
        HybridTimestamp commitTimestamp = HybridTimestamp.readNullableFrom(in);
        return new TxMeta(state, enlistedPartitions, commitTimestamp);
    }

    private static List<EnlistedPartitionGroup> readEnlistedPartitions(IgniteDataInput in, byte protoVer) throws IOException {
        assert (protoVer >= 2) : "Unsupported protocol version [ver=" + protoVer + "].";
        int length = in.readVarIntAsInt();
        ArrayList<EnlistedPartitionGroup> enlistedPartitions = new ArrayList<EnlistedPartitionGroup>(length);
        for (int i = 0; i < length; ++i) {
            int objectId = in.readVarIntAsInt();
            int partitionId = in.readVarIntAsInt();
            Set<Integer> tableIds = TxMetaSerializer.readVarIntSet(in);
            enlistedPartitions.add(new EnlistedPartitionGroup(new ZonePartitionId(objectId, partitionId), tableIds));
        }
        return enlistedPartitions;
    }
}

