/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.TransactionMeta;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.impl.EnlistedPartitionGroup;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxMetaMessage;
import org.jetbrains.annotations.Nullable;

public class TxMeta
implements TransactionMeta {
    private static final long serialVersionUID = -172513482743911860L;
    private final TxState txState;
    private final Collection<EnlistedPartitionGroup> enlistedPartitions;
    @Nullable
    private final HybridTimestamp commitTimestamp;

    public TxMeta(TxState txState, Collection<EnlistedPartitionGroup> enlistedPartitions, @Nullable HybridTimestamp commitTimestamp) {
        this.txState = txState;
        this.enlistedPartitions = enlistedPartitions;
        this.commitTimestamp = commitTimestamp;
    }

    @Override
    public TxState txState() {
        return this.txState;
    }

    public Collection<EnlistedPartitionGroup> enlistedPartitions() {
        return Collections.unmodifiableCollection(this.enlistedPartitions);
    }

    @Override
    @Nullable
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    @Override
    public TxMetaMessage toTransactionMetaMessage(ReplicaMessagesFactory replicaMessagesFactory, TxMessagesFactory txMessagesFactory) {
        ArrayList<EnlistedPartitionGroupMessage> enlistedPartitionMessages = new ArrayList<EnlistedPartitionGroupMessage>(this.enlistedPartitions.size());
        for (EnlistedPartitionGroup enlistedPartition : this.enlistedPartitions) {
            enlistedPartitionMessages.add(txMessagesFactory.enlistedPartitionGroupMessage().groupId(ReplicaMessageUtils.toZonePartitionIdMessage(replicaMessagesFactory, enlistedPartition.groupId())).tableIds(enlistedPartition.tableIds()).build());
        }
        return txMessagesFactory.txMetaMessage().txState(this.txState).commitTimestamp(this.commitTimestamp).enlistedPartitions(enlistedPartitionMessages).build();
    }

    public String toString() {
        return S.toString(TxMeta.class, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxMeta other = (TxMeta)o;
        return this.txState == other.txState && this.enlistedPartitions.equals(other.enlistedPartitions) && Objects.equals(this.commitTimestamp, other.commitTimestamp);
    }

    public int hashCode() {
        int result = this.txState.hashCode();
        result = 31 * result + this.enlistedPartitions.hashCode();
        result = 31 * result + (this.commitTimestamp != null ? this.commitTimestamp.hashCode() : 0);
        return result;
    }
}

