/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.index;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class IndexMeta {
    private final int catalogVersion;
    private final int indexId;
    private final int tableId;
    private final int tableVersionOnIndexCreation;
    private final String indexName;
    private final MetaIndexStatus currentStatus;
    @IgniteToStringInclude
    private final Map<MetaIndexStatus, MetaIndexStatusChange> statusChanges;
    private final NavigableMap<Long, MetaIndexStatus> statusActivationTimeline;

    public IndexMeta(int catalogVersion, int indexId, int tableId, int tableVersion, String indexName, MetaIndexStatus currentStatus, Map<MetaIndexStatus, MetaIndexStatusChange> statusChanges) {
        this.catalogVersion = catalogVersion;
        this.indexId = indexId;
        this.tableId = tableId;
        this.tableVersionOnIndexCreation = tableVersion;
        this.indexName = indexName;
        this.currentStatus = currentStatus;
        this.statusChanges = Collections.unmodifiableMap(statusChanges);
        TreeMap<Long, MetaIndexStatus> timeline = new TreeMap<Long, MetaIndexStatus>();
        for (Map.Entry<MetaIndexStatus, MetaIndexStatusChange> entry : statusChanges.entrySet()) {
            timeline.put(entry.getValue().activationTimestamp(), entry.getKey());
        }
        this.statusActivationTimeline = Collections.unmodifiableNavigableMap(timeline);
    }

    static IndexMeta of(int indexId, Catalog catalog) {
        CatalogIndexDescriptor catalogIndexDescriptor = catalog.index(indexId);
        assert (catalogIndexDescriptor != null) : "indexId=" + indexId + ", catalogVersion=" + catalog.version();
        CatalogTableDescriptor catalogTableDescriptor = catalog.table(catalogIndexDescriptor.tableId());
        assert (catalogTableDescriptor != null) : "indexId=" + indexId + ", tableId=" + catalogIndexDescriptor.tableId() + ", catalogVersion=" + catalog.version();
        return new IndexMeta(catalog.version(), catalogIndexDescriptor.id(), catalogIndexDescriptor.tableId(), catalogTableDescriptor.latestSchemaVersion(), catalogIndexDescriptor.name(), MetaIndexStatus.convert(catalogIndexDescriptor.status()), Map.of(MetaIndexStatus.convert(catalogIndexDescriptor.status()), new MetaIndexStatusChange(catalog.version(), catalog.time())));
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    public int indexId() {
        return this.indexId;
    }

    public int tableId() {
        return this.tableId;
    }

    public int tableVersion() {
        return this.tableVersionOnIndexCreation;
    }

    public String indexName() {
        return this.indexName;
    }

    IndexMeta indexName(int catalogVersion, String newIndexName) {
        return new IndexMeta(catalogVersion, this.indexId, this.tableId, this.tableVersionOnIndexCreation, newIndexName, this.currentStatus, new EnumMap<MetaIndexStatus, MetaIndexStatusChange>(this.statusChanges));
    }

    public MetaIndexStatus status() {
        return this.currentStatus;
    }

    IndexMeta status(MetaIndexStatus newStatus, int catalogVersion, long activationTs) {
        assert (!this.statusChanges.containsKey((Object)newStatus)) : String.format("newStatus=%s, catalogVersion=%d, indexName=%s", new Object[]{newStatus, catalogVersion, this.indexName});
        EnumMap<MetaIndexStatus, MetaIndexStatusChange> newStatuses = new EnumMap<MetaIndexStatus, MetaIndexStatusChange>(this.statusChanges);
        newStatuses.put(newStatus, new MetaIndexStatusChange(catalogVersion, activationTs));
        return new IndexMeta(catalogVersion, this.indexId, this.tableId, this.tableVersionOnIndexCreation, this.indexName, newStatus, newStatuses);
    }

    @Nullable
    public MetaIndexStatus statusAt(long timestamp) {
        Map.Entry<Long, MetaIndexStatus> floorEntry = this.statusActivationTimeline.floorEntry(timestamp);
        return floorEntry != null ? floorEntry.getValue() : null;
    }

    public Map<MetaIndexStatus, MetaIndexStatusChange> statusChanges() {
        return this.statusChanges;
    }

    public MetaIndexStatusChange statusChange(MetaIndexStatus status) {
        MetaIndexStatusChange change = this.statusChanges.get((Object)status);
        if (change == null) {
            throw new IllegalArgumentException(String.format("No status change: [requestedStatus=%s, indexMeta=%s]", new Object[]{status, this}));
        }
        return change;
    }

    @Nullable
    public MetaIndexStatusChange statusChangeNullable(MetaIndexStatus status) {
        return this.statusChanges.get((Object)status);
    }

    public boolean isDropped() {
        switch (this.currentStatus) {
            case STOPPING: 
            case REMOVED: 
            case READ_ONLY: {
                return true;
            }
            case REGISTERED: 
            case BUILDING: 
            case AVAILABLE: {
                return false;
            }
        }
        throw new AssertionError((Object)String.format("Unknown status: [indexId=%s, currentStatus=%s]", new Object[]{this.indexId, this.currentStatus}));
    }

    public boolean isRemovedFromCatalog() {
        switch (this.currentStatus) {
            case REMOVED: 
            case READ_ONLY: {
                return true;
            }
            case STOPPING: 
            case REGISTERED: 
            case BUILDING: 
            case AVAILABLE: {
                return false;
            }
        }
        throw new AssertionError((Object)String.format("Unknown status: [indexId=%s, currentStatus=%s]", new Object[]{this.indexId, this.currentStatus}));
    }

    public String toString() {
        return S.toString(this);
    }
}

