/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.marshaller.Marshaller;
import org.apache.ignite3.internal.marshaller.MarshallerSchema;
import org.apache.ignite3.internal.marshaller.MarshallersProvider;
import org.apache.ignite3.internal.marshaller.TupleReader;
import org.apache.ignite3.internal.marshaller.ValidationUtils;
import org.apache.ignite3.internal.nearcache.EmbeddedNearCacheKeyImpl;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.schema.marshaller.KvMarshaller;
import org.apache.ignite3.internal.schema.marshaller.reflection.KvMarshallerImpl;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.internal.streamer.StreamerBatchSender;
import org.apache.ignite3.internal.table.AbstractTableView;
import org.apache.ignite3.internal.table.DataStreamer;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.KeyValuePojoStreamerPartitionAwarenessProvider;
import org.apache.ignite3.internal.table.criteria.SqlRowProjection;
import org.apache.ignite3.internal.table.distributed.schema.SchemaVersions;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.Pair;
import org.apache.ignite3.internal.util.ViewUtils;
import org.apache.ignite3.lang.MarshallerException;
import org.apache.ignite3.lang.NullableValue;
import org.apache.ignite3.lang.UnexpectedNullValueException;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.table.ContinuousQueryOptions;
import org.apache.ignite3.table.DataStreamerItem;
import org.apache.ignite3.table.DataStreamerOptions;
import org.apache.ignite3.table.DataStreamerReceiverDescriptor;
import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.TableRowEventBatch;
import org.apache.ignite3.table.TableRowEventType;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.tx.Transaction;
import org.gridgain.internal.table.nearcache.NearCacheEntriesProvider;
import org.gridgain.internal.table.nearcache.NearCacheKey;
import org.gridgain.internal.table.nearcache.NearCacheSchemaVersionAwareSubscriber;
import org.gridgain.internal.table.nearcache.NearCacheValue;
import org.jetbrains.annotations.Nullable;

public class KeyValueViewImpl<K, V>
extends AbstractTableView<Map.Entry<K, V>>
implements KeyValueView<K, V>,
NearCacheEntriesProvider<K, V, BinaryRowEx> {
    private final Mapper<K> keyMapper;
    private final Mapper<V> valueMapper;
    private final Function<SchemaDescriptor, KvMarshaller<K, V>> marshallerFactory;
    @Nullable
    private volatile KvMarshaller<K, V> marsh;

    public KeyValueViewImpl(InternalTable tbl, SchemaRegistry schemaRegistry, SchemaVersions schemaVersions, IgniteSql sql, MarshallersProvider marshallers, Mapper<K> keyMapper, Mapper<V> valueMapper) {
        super(tbl, schemaVersions, schemaRegistry, sql, marshallers);
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
        this.marshallerFactory = schema -> new KvMarshallerImpl((SchemaDescriptor)schema, marshallers, keyMapper, valueMapper);
    }

    @Override
    public V get(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return ViewUtils.sync(this.doGet(tx, key, "getNullable"));
    }

    @Override
    public CompletableFuture<V> getAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doGet(tx, key, "getNullableAsync");
    }

    private CompletableFuture<V> doGet(@Nullable Transaction tx, K key, String altMethod) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshalValue((BinaryRow)binaryRow, schemaVersion, altMethod));
        });
    }

    @Override
    public NullableValue<V> getNullable(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valueMapper.targetType(), "getNullable");
        return ViewUtils.sync(this.doGetNullable(tx, key));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valueMapper.targetType(), "getNullableAsync");
        return this.doGetNullable(tx, key);
    }

    private CompletableFuture<NullableValue<V>> doGetNullable(@Nullable Transaction tx, K key) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r, schemaVersion)));
        });
    }

    @Override
    public V getOrDefault(@Nullable Transaction tx, K key, V defaultValue) {
        return ViewUtils.sync(this.getOrDefaultAsync(tx, key, defaultValue));
    }

    @Override
    public CompletableFuture<V> getOrDefaultAsync(@Nullable Transaction tx, K key, V defaultValue) {
        Objects.requireNonNull(key, "key");
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(r -> IgniteUtils.nonNullOrElse(this.unmarshalNullableValue((BinaryRow)r, schemaVersion), defaultValue));
        });
    }

    @Override
    public Map<K, V> getAll(@Nullable Transaction tx, Collection<K> keys) {
        return ViewUtils.sync(this.getAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> rows = this.marshal(keys, schemaVersion);
            return this.tbl.getAll(rows, (InternalTransaction)tx).thenApply(resultRows -> this.unmarshalPairs((Collection<BinaryRow>)resultRows, schemaVersion));
        });
    }

    @Override
    public boolean contains(@Nullable Transaction tx, K key) {
        return ViewUtils.sync(this.containsAsync(tx, key));
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(Objects::nonNull);
        });
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<K> keys) {
        return ViewUtils.sync(this.containsAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        if (keys.isEmpty()) {
            return CompletableFutures.trueCompletedFuture();
        }
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> keyRows = this.marshal(keys, schemaVersion);
            return this.tbl.getAll(keyRows, (InternalTransaction)tx).thenApply(rows -> {
                for (BinaryRow row : rows) {
                    if (row != null) continue;
                    return false;
                }
                return true;
            });
        });
    }

    @Override
    public void put(@Nullable Transaction tx, K key, @Nullable V val) {
        ViewUtils.sync(this.putAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Void> putAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valueMapper.targetType());
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.upsert(row, (InternalTransaction)tx);
        });
    }

    @Override
    public void putAll(@Nullable Transaction tx, Map<K, V> pairs) {
        ViewUtils.sync(this.putAllAsync(tx, pairs));
    }

    @Override
    public CompletableFuture<Void> putAllAsync(@Nullable Transaction tx, Map<K, V> pairs) {
        Objects.requireNonNull(pairs, "pairs");
        for (Map.Entry<K, V> entry : pairs.entrySet()) {
            K key = entry.getKey();
            V val = entry.getValue();
            Objects.requireNonNull(key, "key");
            ValidationUtils.validateNullableValue(val, this.valueMapper.targetType());
        }
        return this.doOperation(tx, schemaVersion -> {
            List<BinaryRowEx> rows = this.marshalPairs(pairs.entrySet(), schemaVersion, null);
            return this.tbl.upsertAll(rows, (InternalTransaction)tx);
        });
    }

    @Override
    public V getAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valueMapper.targetType());
        return ViewUtils.sync(this.doGetAndPut(tx, key, val, "getNullableAndPut"));
    }

    @Override
    public CompletableFuture<V> getAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valueMapper.targetType());
        return this.doGetAndPut(tx, key, val, "getNullableAndPutAsync");
    }

    private CompletableFuture<V> doGetAndPut(@Nullable Transaction tx, K key, @Nullable V val, String altMethod) {
        return this.doOperation(tx, schemaVersion -> this.tbl.getAndUpsert(this.marshal(key, val, schemaVersion), (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshalValue((BinaryRow)binaryRow, schemaVersion, altMethod)));
    }

    @Override
    public NullableValue<V> getNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valueMapper.targetType(), "getNullableAndPut");
        return ViewUtils.sync(this.doGetNullableAndPut(tx, key, val));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndPutAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valueMapper.targetType(), "getNullableAndPutAsync");
        return this.doGetNullableAndPut(tx, key, val);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndPut(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.getAndUpsert(row, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r, schemaVersion)));
        });
    }

    @Override
    public boolean putIfAbsent(@Nullable Transaction tx, K key, @Nullable V val) {
        return ViewUtils.sync(this.putIfAbsentAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> putIfAbsentAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valueMapper.targetType());
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.insert(row, (InternalTransaction)tx);
        });
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key) {
        return ViewUtils.sync(this.removeAsync(tx, key));
    }

    @Override
    public boolean remove(@Nullable Transaction tx, K key, @Nullable V val) {
        return ViewUtils.sync(this.removeAsync(tx, key, val));
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, schemaVersion);
            return this.tbl.delete(row, (InternalTransaction)tx);
        });
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valueMapper.targetType());
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.deleteExact(row, (InternalTransaction)tx);
        });
    }

    @Override
    public void removeAll(@Nullable Transaction tx) {
        ViewUtils.sync(this.removeAllAsync(tx));
    }

    @Override
    public Collection<K> removeAll(@Nullable Transaction tx, Collection<K> keys) {
        return ViewUtils.sync(this.removeAllAsync(tx, keys));
    }

    @Override
    public CompletableFuture<Void> removeAllAsync(@Nullable Transaction tx) {
        return this.sql.executeAsync(tx, "DELETE FROM " + this.tbl.name().toCanonicalForm(), new Object[0]).thenApply(r -> null);
    }

    @Override
    public CompletableFuture<Collection<K>> removeAllAsync(@Nullable Transaction tx, Collection<K> keys) {
        ViewUtils.checkKeysForNulls(keys);
        return this.doOperation(tx, schemaVersion -> {
            Collection<BinaryRowEx> rows = this.marshal(keys, schemaVersion);
            return this.tbl.deleteAll(rows, (InternalTransaction)tx).thenApply(resultRows -> this.unmarshalKeys((Collection<BinaryRow>)resultRows, schemaVersion));
        });
    }

    @Override
    public V getAndRemove(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return ViewUtils.sync(this.doGetAndRemove(tx, key, "getNullableAndRemove"));
    }

    @Override
    public CompletableFuture<V> getAndRemoveAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        return this.doGetAndRemove(tx, key, "getNullableAndRemoveAsync");
    }

    private CompletableFuture<V> doGetAndRemove(@Nullable Transaction tx, K key, String altMethod) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.getAndDelete(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshalValue((BinaryRow)binaryRow, schemaVersion, altMethod));
        });
    }

    @Override
    public NullableValue<V> getNullableAndRemove(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valueMapper.targetType(), "getNullableAndRemove");
        return ViewUtils.sync(this.doGetNullableAndRemove(tx, key));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndRemoveAsync(@Nullable Transaction tx, K key) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valueMapper.targetType(), "getNullableAndRemoveAsync");
        return this.doGetNullableAndRemove(tx, key);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndRemove(@Nullable Transaction tx, K key) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return this.tbl.getAndDelete(keyRow, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r, schemaVersion)));
        });
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, @Nullable V val) {
        return ViewUtils.sync(this.replaceAsync(tx, key, val));
    }

    @Override
    public boolean replace(@Nullable Transaction tx, K key, @Nullable V oldVal, @Nullable V newVal) {
        return ViewUtils.sync(this.replaceAsync(tx, key, oldVal, newVal));
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valueMapper.targetType());
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.replace(row, (InternalTransaction)tx);
        });
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, K key, @Nullable V oldVal, @Nullable V newVal) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(oldVal, this.valueMapper.targetType());
        ValidationUtils.validateNullableValue(newVal, this.valueMapper.targetType());
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx oldRow = this.marshal(key, oldVal, schemaVersion);
            BinaryRowEx newRow = this.marshal(key, newVal, schemaVersion);
            return this.tbl.replace(oldRow, newRow, (InternalTransaction)tx);
        });
    }

    @Override
    public V getAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valueMapper.targetType());
        return ViewUtils.sync(this.doGetAndReplace(tx, key, val, "getNullableAndReplace"));
    }

    @Override
    public CompletableFuture<V> getAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableValue(val, this.valueMapper.targetType());
        return this.doGetAndReplace(tx, key, val, "getNullableAndReplaceAsync");
    }

    private CompletableFuture<V> doGetAndReplace(@Nullable Transaction tx, K key, @Nullable V val, String altMethod) {
        return this.doOperation(tx, schemaVersion -> this.tbl.getAndReplace(this.marshal(key, val, schemaVersion), (InternalTransaction)tx).thenApply(binaryRow -> this.unmarshalValue((BinaryRow)binaryRow, schemaVersion, altMethod)));
    }

    @Override
    public NullableValue<V> getNullableAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valueMapper.targetType(), "getNullableAndReplace");
        return ViewUtils.sync(this.doGetNullableAndReplace(tx, key, val));
    }

    @Override
    public CompletableFuture<NullableValue<V>> getNullableAndReplaceAsync(@Nullable Transaction tx, K key, @Nullable V val) {
        Objects.requireNonNull(key, "key");
        ValidationUtils.validateNullableOperation(this.valueMapper.targetType(), "getNullableAndReplaceAsync");
        return this.doGetNullableAndReplace(tx, key, val);
    }

    private CompletableFuture<NullableValue<V>> doGetNullableAndReplace(@Nullable Transaction tx, K key, @Nullable V val) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx row = this.marshal(key, val, schemaVersion);
            return this.tbl.getAndReplace(row, (InternalTransaction)tx).thenApply(r -> r == null ? null : NullableValue.of(this.unmarshalNullableValue((BinaryRow)r, schemaVersion)));
        });
    }

    private KvMarshaller<K, V> marshaller(int schemaVersion) {
        KvMarshaller<K, V> marsh = this.marsh;
        if (marsh != null && marsh.schemaVersion() == schemaVersion) {
            return marsh;
        }
        try {
            SchemaRegistry registry = this.rowConverter.registry();
            marsh = this.marshallerFactory.apply(registry.schema(schemaVersion));
            this.marsh = marsh;
        }
        catch (Exception ex) {
            throw new MarshallerException(ex.getMessage(), (Throwable)ex);
        }
        return marsh;
    }

    private BinaryRowEx marshal(K key, int schemaVersion) {
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        return marsh.marshal(key);
    }

    private BinaryRowEx marshal(K key, @Nullable V val, int schemaVersion) {
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        return marsh.marshal(key, val);
    }

    private Collection<BinaryRowEx> marshal(Collection<K> keys, int schemaVersion) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        ArrayList<BinaryRowEx> keyRows = new ArrayList<BinaryRowEx>(keys.size());
        for (K key : keys) {
            keyRows.add(marsh.marshal(Objects.requireNonNull(key)));
        }
        return keyRows;
    }

    private List<BinaryRowEx> marshalPairs(Collection<Map.Entry<K, V>> pairs, int schemaVersion, @Nullable BitSet deleted) {
        if (pairs.isEmpty()) {
            return Collections.emptyList();
        }
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        ArrayList<BinaryRowEx> rows = new ArrayList<BinaryRowEx>(pairs.size());
        for (Map.Entry<K, V> pair : pairs) {
            boolean isDeleted = deleted != null && deleted.get(rows.size());
            K key = Objects.requireNonNull(pair.getKey());
            Row row = isDeleted ? marsh.marshal(key) : marsh.marshal(key, pair.getValue());
            rows.add(row);
        }
        return rows;
    }

    private Collection<K> unmarshalKeys(Collection<BinaryRow> rows, int schemaVersion) {
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        ArrayList<K> keys = new ArrayList<K>(rows.size());
        for (Row row : this.rowConverter.resolveKeys(rows, schemaVersion)) {
            if (row == null) continue;
            keys.add(marsh.unmarshalKeyOnly(row));
        }
        return keys;
    }

    @Nullable
    private V unmarshalNullableValue(@Nullable BinaryRow binaryRow, int schemaVersion) {
        if (binaryRow == null) {
            return null;
        }
        Row row = this.rowConverter.resolveRow(binaryRow, schemaVersion);
        KvMarshaller<K, V> marshaller = this.marshaller(row.schemaVersion());
        return marshaller.unmarshalValue(row);
    }

    private Map<K, V> unmarshalPairs(Collection<BinaryRow> rows, int schemaVersion) {
        if (rows.isEmpty()) {
            return Collections.emptyMap();
        }
        KvMarshaller<K, V> marsh = this.marshaller(schemaVersion);
        HashMap<K, V> pairs = IgniteUtils.newHashMap(rows.size());
        for (Row row : this.rowConverter.resolveRows(rows, schemaVersion)) {
            if (row == null) continue;
            pairs.put(marsh.unmarshalKey(row), marsh.unmarshalValue(row));
        }
        return pairs;
    }

    @Nullable
    private V unmarshalValue(@Nullable BinaryRow binaryRow, int schemaVersion, String altMethod) {
        if (binaryRow == null) {
            return null;
        }
        V v = this.unmarshalNullableValue(binaryRow, schemaVersion);
        if (v == null) {
            throw new UnexpectedNullValueException(IgniteStringFormatter.format("Got unexpected null value: use `{}` sibling method instead.", altMethod));
        }
        return v;
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<Map.Entry<K, V>>> publisher, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher, "publisher");
        StreamerBatchSender batchSender = (partitionId, items, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.withSchemaSync(null, schemaVersion -> this.tbl.updateAll((Collection<BinaryRowEx>)this.marshalPairs(items, schemaVersion, deleted), deleted, (int)partitionId)));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, options, batchSender, this.streamerPartitioner(), this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    @Override
    public <E, V1, A, R> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V1, A, R> receiver, Function<E, Map.Entry<K, V>> keyFunc, Function<E, V1> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R> resultSubscriber, @Nullable DataStreamerOptions options) {
        Objects.requireNonNull(publisher);
        Objects.requireNonNull(keyFunc);
        Objects.requireNonNull(payloadFunc);
        Objects.requireNonNull(receiver);
        StreamerBatchSender batchSender = (partitionIndex, rows, deleted) -> PublicApiThreading.execUserAsyncOperation(() -> this.tbl.partitionLocation((int)partitionIndex).thenCompose(node -> this.tbl.streamerReceiverRunner().runReceiverAsync(receiver, receiverArg, rows, (InternalClusterNode)node, receiver.units())));
        CompletableFuture<Void> future = DataStreamer.streamData(publisher, keyFunc, payloadFunc, x -> false, options, batchSender, resultSubscriber, this.streamerPartitioner(), this.tbl.streamerFlushExecutor());
        return IgniteExceptionMapperUtil.convertToPublicFuture(future);
    }

    private KeyValuePojoStreamerPartitionAwarenessProvider<K, V> streamerPartitioner() {
        return new KeyValuePojoStreamerPartitionAwarenessProvider<K, V>(this.rowConverter.registry(), this.tbl.partitions(), this.marshaller(this.rowConverter.registry().lastKnownSchemaVersion()));
    }

    @Override
    protected Function<SqlRow, Map.Entry<K, V>> queryMapper(ResultSetMetadata meta, SchemaDescriptor schema) {
        List<Column> keyCols = schema.keyColumns();
        List<Column> valCols = schema.valueColumns();
        MarshallerSchema marshallerSchema = schema.marshallerSchema();
        Marshaller keyMarsh = this.marshallers.getKeysMarshaller(marshallerSchema, this.keyMapper, false, true);
        Marshaller valMarsh = this.marshallers.getValuesMarshaller(marshallerSchema, this.valueMapper, false, true);
        return row -> new IgniteBiTuple<Object, Object>(keyMarsh.readObject(new TupleReader(new SqlRowProjection((SqlRow)row, meta, KeyValueViewImpl.columnNames(keyCols))), null), valMarsh.readObject(new TupleReader(new SqlRowProjection((SqlRow)row, meta, KeyValueViewImpl.columnNames(valCols))), null));
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<Map.Entry<K, V>>> subscriber, @Nullable ContinuousQueryOptions options) {
        Objects.requireNonNull(subscriber);
        BiFunction<BinaryRow, SchemaDescriptor, Map.Entry> mapper = (binaryRow, schema) -> {
            Row row = this.rowConverter.resolveRow((BinaryRow)binaryRow, binaryRow.schemaVersion());
            KvMarshaller<K, V> marsh = this.marshaller(binaryRow.schemaVersion());
            try {
                K key = marsh.unmarshalKey(row);
                V val = marsh.unmarshalValue(row);
                return new IgniteBiTuple<K, V>(key, val);
            }
            catch (MarshallerException e) {
                throw new MarshallerException(e);
            }
        };
        this.tbl.queryContinuously(subscriber, options, mapper);
    }

    @Override
    public Class<V> valueType() {
        return this.valueMapper.targetType();
    }

    @Override
    public CompletableFuture<NearCacheKey<K, BinaryRowEx>> getNearCacheKeyAsync(K key, boolean enforceKeyOnly) {
        return this.doOperation(null, schemaVersion -> {
            BinaryRowEx keyRow = this.marshal(key, schemaVersion);
            return CompletableFuture.completedFuture(new EmbeddedNearCacheKeyImpl<Object>(key, keyRow));
        });
    }

    @Override
    public CompletableFuture<Collection<NearCacheKey<K, BinaryRowEx>>> getNearCacheKeysAsync(Iterable<? extends K> keys, boolean enforceKeyOnly) {
        return this.doOperation(null, schemaVersion -> {
            ArrayList cacheKeys = new ArrayList();
            for (Object keyRec : keys) {
                BinaryRowEx keyRow = this.marshal(keyRec, schemaVersion);
                EmbeddedNearCacheKeyImpl cacheKey = new EmbeddedNearCacheKeyImpl(keyRec, keyRow);
                cacheKeys.add(cacheKey);
            }
            return CompletableFuture.completedFuture(cacheKeys);
        });
    }

    @Override
    public CompletableFuture<Pair<NearCacheKey<K, BinaryRowEx>, NearCacheValue<V>>> getNearCacheValueAsync(@Nullable Transaction tx, NearCacheKey<K, BinaryRowEx> key) {
        return this.doOperation(tx, schemaVersion -> {
            BinaryRowEx keyRow = (BinaryRowEx)key.serializedKey();
            if (keyRow == null || schemaVersion != keyRow.schemaVersion()) {
                keyRow = this.marshal(key.key(), schemaVersion);
            }
            EmbeddedNearCacheKeyImpl finalCacheKey = new EmbeddedNearCacheKeyImpl(key.key(), keyRow);
            return this.tbl.get(keyRow, (InternalTransaction)tx).thenApply(binaryRow -> {
                NearCacheValue cacheVal;
                if (binaryRow == null) {
                    cacheVal = new NearCacheValue();
                } else {
                    @Nullable V val = this.unmarshalNullableValue((BinaryRow)binaryRow, schemaVersion);
                    cacheVal = new NearCacheValue<V>(val);
                }
                return new Pair(finalCacheKey, cacheVal);
            });
        });
    }

    @Override
    public CompletableFuture<Map<NearCacheKey<K, BinaryRowEx>, NearCacheValue<V>>> getNearCacheValuesAsync(@Nullable Transaction tx, Collection<NearCacheKey<K, BinaryRowEx>> nearCacheKeys) {
        return this.doOperation(tx, schemaVersion -> {
            ArrayList ncKeys = new ArrayList(nearCacheKeys.size());
            ArrayList<BinaryRowEx> keyRows = new ArrayList<BinaryRowEx>(nearCacheKeys.size());
            for (NearCacheKey nearCacheKey : nearCacheKeys) {
                BinaryRowEx keyRow = (BinaryRowEx)nearCacheKey.serializedKey();
                if (keyRow == null || schemaVersion != keyRow.schemaVersion()) {
                    keyRow = this.marshal(nearCacheKey.key(), schemaVersion);
                }
                keyRows.add(keyRow);
                ncKeys.add(new EmbeddedNearCacheKeyImpl(nearCacheKey.key(), keyRow));
            }
            return this.tbl.getAll(keyRows, (InternalTransaction)tx).thenApply(rows -> {
                assert (rows.size() == keyRows.size());
                HashMap ret = new HashMap(rows.size());
                for (int i = 0; i < rows.size(); ++i) {
                    NearCacheValue cacheVal;
                    BinaryRow binaryRow = (BinaryRow)rows.get(i);
                    if (binaryRow == null) {
                        cacheVal = new NearCacheValue();
                    } else {
                        @Nullable V val = this.unmarshalNullableValue(binaryRow, schemaVersion);
                        cacheVal = new NearCacheValue<V>(val);
                    }
                    NearCacheKey nearCacheKey = (NearCacheKey)ncKeys.get(i);
                    ret.put(nearCacheKey, cacheVal);
                }
                return ret;
            });
        });
    }

    @Override
    public void subscribeToNearCacheUpdates(Flow.Subscriber<TableRowEventBatch<Map.Entry<K, V>>> subscriber, int updateInterval) {
        ContinuousQueryOptions opts = ContinuousQueryOptions.builder().pollIntervalMs(updateInterval).eventTypes(TableRowEventType.CREATED, TableRowEventType.UPDATED, TableRowEventType.REMOVED).build();
        this.queryContinuously((Flow.Subscriber<TableRowEventBatch<Map.Entry<K, V>>>)new NearCacheSchemaVersionAwareSubscriber<Map.Entry<K, V>>(subscriber, () -> this.doOperation(null, CompletableFuture::completedFuture)), opts);
    }

    @Override
    public void close() throws Exception {
    }
}

