/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb.index;

import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.apache.ignite3.internal.rocksdb.RocksUtils;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.BinaryTuplePrefix;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.index.IndexRow;
import org.apache.ignite3.internal.storage.index.IndexRowImpl;
import org.apache.ignite3.internal.storage.index.PeekCursor;
import org.apache.ignite3.internal.storage.index.SortedIndexStorage;
import org.apache.ignite3.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite3.internal.storage.rocksdb.IgniteRocksDbException;
import org.apache.ignite3.internal.storage.rocksdb.PartitionDataHelper;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbMetaStorage;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbStorageUtils;
import org.apache.ignite3.internal.storage.rocksdb.index.AbstractRocksDbIndexStorage;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;

public class RocksDbSortedIndexStorage
extends AbstractRocksDbIndexStorage
implements SortedIndexStorage {
    private final ColumnFamily indexCf;
    private final byte[] partitionStartPrefix;
    private final byte[] partitionEndPrefix;

    public RocksDbSortedIndexStorage(StorageSortedIndexDescriptor descriptor, int tableId, int partitionId, ColumnFamily indexCf, RocksDbMetaStorage indexMetaStorage) {
        super(descriptor, tableId, partitionId, indexMetaStorage);
        this.indexCf = indexCf;
        this.partitionStartPrefix = ByteBuffer.allocate(10).order(RocksDbStorageUtils.KEY_BYTE_ORDER).putInt(tableId).putInt(descriptor.id()).putShort((short)partitionId).array();
        this.partitionEndPrefix = RocksUtils.incrementPrefix(this.partitionStartPrefix);
    }

    @Override
    public StorageSortedIndexDescriptor indexDescriptor() {
        return (StorageSortedIndexDescriptor)this.descriptor;
    }

    @Override
    public Cursor<RowId> get(BinaryTuple key) throws StorageException {
        return this.busyDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            this.throwExceptionIfIndexNotBuilt();
            BinaryTuplePrefix keyPrefix = BinaryTuplePrefix.fromBinaryTuple(key);
            return this.scan(keyPrefix, keyPrefix, true, true, this::decodeRowId);
        });
    }

    @Override
    public void put(IndexRow row) {
        this.busyNonDataRead(() -> {
            try {
                WriteBatchWithIndex writeBatch = PartitionDataHelper.requireWriteBatch();
                writeBatch.put(this.indexCf.handle(), this.rocksKey(row), ArrayUtils.BYTE_EMPTY_ARRAY);
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Unable to insert data into sorted index. Index ID: " + this.descriptor.id(), e);
            }
        });
    }

    @Override
    public void remove(IndexRow row) {
        this.busyNonDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            try {
                WriteBatchWithIndex writeBatch = PartitionDataHelper.requireWriteBatch();
                writeBatch.delete(this.indexCf.handle(), this.rocksKey(row));
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Unable to remove data from sorted index. Index ID: " + this.descriptor.id(), e);
            }
        });
    }

    @Override
    public PeekCursor<IndexRow> scan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        return this.scanInternal(lowerBound, upperBound, flags, true);
    }

    protected <T> PeekCursor<T> scan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, boolean includeLower, boolean includeUpper, final Function<ByteBuffer, T> mapper) {
        byte[] lowerBoundBytes = this.getBound(lowerBound, this.partitionStartPrefix, !includeLower);
        byte[] upperBoundBytes = this.getBound(upperBound, this.partitionEndPrefix, includeUpper);
        return new AbstractRocksDbIndexStorage.UpToDatePeekCursor<T>(upperBoundBytes, this.indexCf, lowerBoundBytes){

            @Override
            protected T map(ByteBuffer byteBuffer) {
                return mapper.apply(byteBuffer);
            }
        };
    }

    @Override
    public Cursor<IndexRow> readOnlyScan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        return this.busyDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            this.throwExceptionIfIndexNotBuilt();
            boolean includeLower = (flags & 1) != 0;
            boolean includeUpper = (flags & 2) != 0;
            byte[] lowerBoundBytes = this.getBound(lowerBound, this.partitionStartPrefix, !includeLower);
            byte[] upperBoundBytes = this.getBound(upperBound, this.partitionEndPrefix, includeUpper);
            final Slice upperBoundSlice = new Slice(upperBoundBytes);
            final ReadOptions readOptions = new ReadOptions().setIterateUpperBound(upperBoundSlice);
            final RocksIterator iterator = this.indexCf.newIterator(readOptions);
            iterator.seek(lowerBoundBytes);
            return new Cursor<IndexRow>(){
                private final RocksIterator it;
                private byte[] key;
                private boolean advance;
                {
                    this.it = iterator;
                }

                @Override
                public void close() {
                    try {
                        IgniteUtils.closeAll(this.it, readOptions, upperBoundSlice);
                    }
                    catch (Exception e) {
                        throw new StorageException("Error closing RocksDB RO cursor", (Throwable)e);
                    }
                }

                @Override
                public boolean hasNext() {
                    return RocksDbSortedIndexStorage.this.busyDataRead(this::advanceIfNeededBusy);
                }

                @Override
                public IndexRow next() {
                    return RocksDbSortedIndexStorage.this.busyDataRead(() -> {
                        if (!this.advanceIfNeededBusy()) {
                            throw new NoSuchElementException();
                        }
                        this.advance = true;
                        return RocksDbSortedIndexStorage.this.decodeRow(ByteBuffer.wrap(this.key).order(RocksDbStorageUtils.KEY_BYTE_ORDER));
                    });
                }

                private boolean advanceIfNeededBusy() throws StorageException {
                    StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)RocksDbSortedIndexStorage.this.state.get()), () -> RocksDbSortedIndexStorage.this.createStorageInfo());
                    if (this.advance) {
                        this.it.next();
                        this.advance = false;
                    }
                    if (!this.it.isValid()) {
                        return false;
                    }
                    this.key = this.it.key();
                    return true;
                }
            };
        });
    }

    @Override
    public PeekCursor<IndexRow> tolerantScan(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags) {
        return this.scanInternal(lowerBound, upperBound, flags, false);
    }

    private byte[] getBound(@Nullable BinaryTuplePrefix bound, byte[] partitionPrefix, boolean changeBoundIncluded) {
        byte[] boundBytes;
        if (bound == null) {
            boundBytes = partitionPrefix;
        } else {
            boundBytes = this.rocksPrefix(bound);
            if (changeBoundIncluded) {
                RocksDbSortedIndexStorage.setEqualityFlag(boundBytes);
            }
        }
        return boundBytes;
    }

    private static void setEqualityFlag(byte[] prefix) {
        prefix[10] = (byte)(prefix[10] | 0x10);
    }

    private IndexRow decodeRow(ByteBuffer bytes) {
        assert (bytes.getShort(8) == this.partitionId);
        BinaryTuple tuple = new BinaryTuple(this.indexDescriptor().binaryTupleSchema().elementCount(), RocksDbSortedIndexStorage.binaryTupleSlice(bytes));
        return new IndexRowImpl(tuple, this.decodeRowId(bytes));
    }

    private RowId decodeRowId(ByteBuffer bytes) {
        long mostSignificantBits = bytes.getLong(bytes.limit() - 16);
        long leastSignificantBits = bytes.getLong(bytes.limit() - 8);
        return new RowId(this.partitionId, mostSignificantBits, leastSignificantBits);
    }

    private byte[] rocksPrefix(BinaryTuplePrefix prefix) {
        ByteBuffer bytes = prefix.byteBuffer();
        return ByteBuffer.allocate(10 + bytes.remaining()).order(RocksDbStorageUtils.KEY_BYTE_ORDER).put(this.partitionStartPrefix).put(bytes).array();
    }

    private byte[] rocksKey(IndexRow row) {
        ByteBuffer bytes = row.indexColumns().byteBuffer();
        return ByteBuffer.allocate(10 + bytes.remaining() + 16).order(RocksDbStorageUtils.KEY_BYTE_ORDER).put(this.partitionStartPrefix).put(bytes).putLong(row.rowId().mostSignificantBits()).putLong(row.rowId().leastSignificantBits()).array();
    }

    private static ByteBuffer binaryTupleSlice(ByteBuffer key) {
        return key.duplicate().position(10).limit(key.limit() - 16).slice().order(BinaryTuple.ORDER);
    }

    @Override
    public void clearIndex(WriteBatch writeBatch) throws RocksDBException {
        writeBatch.deleteRange(this.indexCf.handle(), this.partitionStartPrefix, this.partitionEndPrefix);
    }

    private PeekCursor<IndexRow> scanInternal(@Nullable BinaryTuplePrefix lowerBound, @Nullable BinaryTuplePrefix upperBound, int flags, boolean onlyBuiltIndex) {
        return this.busyDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            if (onlyBuiltIndex) {
                this.throwExceptionIfIndexNotBuilt();
            }
            boolean includeLower = (flags & 1) != 0;
            boolean includeUpper = (flags & 2) != 0;
            return this.scan(lowerBound, upperBound, includeLower, includeUpper, this::decodeRow);
        });
    }
}

