/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.util.function.Supplier;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.io.DataPageIo;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.util.PageHandler;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.storage.pagememory.mv.AbstractPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite3.internal.storage.pagememory.mv.PersistentPageMemoryMvPartitionStorage;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersionOperations;
import org.apache.ignite3.internal.storage.pagememory.mv.WiLinkableRowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.WriteIntentListSupport;
import org.apache.ignite3.internal.util.GridUnsafe;

class WiLinkableRowVersionOperations
implements RowVersionOperations {
    private final WiLinkableRowVersion rowVersion;

    WiLinkableRowVersionOperations(WiLinkableRowVersion rowVersion) {
        this.rowVersion = rowVersion;
    }

    @Override
    public void removeFromWriteIntentsList(AbstractPageMemoryMvPartitionStorage storage, Supplier<String> operationInfoSupplier) {
        assert (storage instanceof PersistentPageMemoryMvPartitionStorage);
        WriteIntentListSupport.removeNodeFromWriteIntentsList(this.rowVersion.link(), (PersistentPageMemoryMvPartitionStorage)storage, operationInfoSupplier);
    }

    @Override
    public PageHandler<HybridTimestamp, Object> converterToCommittedVersion() {
        return ConvertToCommittedVersion.INSTANCE;
    }

    private static class ConvertToCommittedVersion
    implements PageHandler<HybridTimestamp, Object> {
        private static final ConvertToCommittedVersion INSTANCE = new ConvertToCommittedVersion();

        private ConvertToCommittedVersion() {
        }

        @Override
        public Object run(int groupId, long pageId, long page, long pageAddr, PageIo io, HybridTimestamp timestamp, int itemId) {
            DataPageIo dataIo = (DataPageIo)io;
            int payloadOffset = dataIo.getPayloadOffset(pageAddr, itemId, GridUnsafe.pageSize(), 0);
            PageUtils.putByte(pageAddr, payloadOffset + 0, (byte)3);
            HybridTimestamps.writeTimestampToMemory(pageAddr, payloadOffset + 1, timestamp);
            PartitionlessLinks.writePartitionless(pageAddr + (long)payloadOffset + 29L, 0L);
            PartitionlessLinks.writePartitionless(pageAddr + (long)payloadOffset + 35L, 0L);
            PageUtils.putLong(pageAddr, payloadOffset + 21, 0L);
            return true;
        }
    }
}

