/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.Storable;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite3.internal.storage.pagememory.mv.PlainRowVersionOperations;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersionOperations;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class RowVersion
implements Storable {
    public static final byte DATA_TYPE = 0;
    private static final int NEXT_LINK_STORE_SIZE_BYTES = 6;
    private static final int VALUE_SIZE_STORE_SIZE_BYTES = 4;
    protected static final int SCHEMA_VERSION_SIZE_BYTES = 2;
    public static final int TIMESTAMP_OFFSET = 1;
    public static final int NEXT_LINK_OFFSET = 9;
    public static final int VALUE_SIZE_OFFSET = 15;
    public static final int SCHEMA_VERSION_OFFSET = 19;
    public static final int VALUE_OFFSET = 21;
    public static final int IS_ARCHIVED = 1;
    private final int partitionId;
    private long link;
    @Nullable
    private final HybridTimestamp timestamp;
    private final long nextLink;
    private final int valueSize;
    private final boolean isArchived;
    @IgniteToStringExclude
    @Nullable
    private final BinaryRow value;

    public RowVersion(int partitionId, long nextLink, @Nullable BinaryRow value, boolean isArchived) {
        this(partitionId, 0L, null, nextLink, value == null ? 0 : value.tupleSliceLength(), value, isArchived);
    }

    public RowVersion(int partitionId, HybridTimestamp commitTimestamp, long nextLink, @Nullable BinaryRow value, boolean isArchived) {
        this(partitionId, 0L, commitTimestamp, nextLink, value == null ? 0 : value.tupleSliceLength(), value, isArchived);
    }

    public RowVersion(int partitionId, long link, @Nullable HybridTimestamp commitTimestamp, long nextLink, int valueSize, boolean isArchived) {
        this(partitionId, link, commitTimestamp, nextLink, valueSize, null, isArchived);
    }

    public RowVersion(int partitionId, long link, @Nullable HybridTimestamp timestamp, long nextLink, int valueSize, @Nullable BinaryRow value, boolean isArchived) {
        this.partitionId = partitionId;
        this.link(link);
        this.timestamp = timestamp;
        this.nextLink = nextLink;
        this.valueSize = valueSize;
        this.value = value;
        this.isArchived = isArchived;
    }

    @Nullable
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public long nextLink() {
        return this.nextLink;
    }

    public int valueSize() {
        return this.valueSize;
    }

    @Nullable
    public BinaryRow value() {
        return this.value;
    }

    public boolean hasNextLink() {
        return this.nextLink != 0L;
    }

    boolean isTombstone() {
        return this.valueSize == 0;
    }

    boolean isUncommitted() {
        return this.timestamp == null;
    }

    boolean isArchived() {
        return this.isArchived;
    }

    boolean isCommitted() {
        return this.timestamp != null;
    }

    @Override
    public void link(long link) {
        this.link = link;
    }

    @Override
    public long link() {
        return this.link;
    }

    @Override
    public int partition() {
        return this.partitionId;
    }

    @Override
    public int size() {
        return this.headerSize() + this.valueSize;
    }

    @Override
    public int headerSize() {
        int baseHeaderSize = 21;
        if (this.value == null) {
            return baseHeaderSize + 1;
        }
        return baseHeaderSize;
    }

    @Override
    public final void writeRowData(long pageAddr, int dataOff, int payloadSize, boolean newRow) {
        PageUtils.putShort(pageAddr, dataOff, (short)payloadSize);
        this.writeHeader(pageAddr, dataOff += 2);
        if (this.value != null) {
            PageUtils.putByteBuffer(pageAddr, dataOff + this.valueOffset(), this.value.tupleSlice());
        } else {
            PageUtils.putByte(pageAddr, dataOff + this.valueOffset(), (byte)(this.isArchived ? 1 : 0));
        }
    }

    protected byte dataType() {
        return 0;
    }

    protected int valueOffset() {
        return 21;
    }

    @Override
    public final void writeFragmentData(ByteBuffer pageBuf, int rowOff, int payloadSize) {
        int bufferSize;
        int bufferOffset;
        int headerSize = this.headerSize();
        if (rowOff == 0) {
            assert (headerSize <= payloadSize) : "Header must entirely fit in the first fragment, but header size is " + headerSize + " and payload size is " + payloadSize;
            this.writeHeader(pageBuf);
            if (this.value == null) {
                pageBuf.put((byte)(this.isArchived ? 1 : 0));
            }
            bufferOffset = 0;
            bufferSize = payloadSize - headerSize;
        } else {
            assert (rowOff >= headerSize);
            bufferOffset = rowOff - headerSize;
            bufferSize = payloadSize;
        }
        if (this.value != null) {
            Storable.putValueBufferIntoPage(pageBuf, this.value.tupleSlice(), bufferOffset, bufferSize);
        }
    }

    protected void writeHeader(long pageAddr, int dataOff) {
        PageUtils.putByte(pageAddr, dataOff + 0, this.dataType());
        this.writeTimestamp(pageAddr, dataOff);
        PartitionlessLinks.writePartitionless(pageAddr + (long)dataOff + 9L, this.nextLink());
        PageUtils.putInt(pageAddr, dataOff + 15, this.valueSize());
        PageUtils.putShort(pageAddr, dataOff + 19, this.schemaVersionOrZero());
    }

    protected void writeHeader(ByteBuffer pageBuf) {
        pageBuf.put(this.dataType());
        this.writeToTimestampSlot(pageBuf);
        PartitionlessLinks.writeToBuffer(pageBuf, this.nextLink());
        pageBuf.putInt(this.valueSize());
        pageBuf.putShort(this.schemaVersionOrZero());
    }

    protected void writeTimestamp(long pageAddr, int dataOff) {
        HybridTimestamps.writeTimestampToMemory(pageAddr, dataOff + 1, this.timestamp());
    }

    protected void writeToTimestampSlot(ByteBuffer pageBuf) {
        HybridTimestamps.writeTimestampToBuffer(pageBuf, this.timestamp());
    }

    private short schemaVersionOrZero() {
        return this.value == null ? (short)0 : (short)this.value.schemaVersion();
    }

    RowVersionOperations operations() {
        return PlainRowVersionOperations.INSTANCE;
    }

    static long readNextLink(int partitionId, long pageAddr, int offset) {
        return PartitionlessLinks.readPartitionless(partitionId, pageAddr, offset + 9);
    }

    public String toString() {
        return S.toString(RowVersion.class, this);
    }
}

