/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import java.util.function.Predicate;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite3.internal.pagememory.io.DataPagePayload;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.storage.pagememory.mv.ReadRowVersionValue;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersionReader;
import org.jetbrains.annotations.Nullable;

class ReadRowVersion
implements PageMemoryTraversal<Predicate<HybridTimestamp>> {
    private final int partitionId;
    private RowVersion result;
    private boolean readingFirstSlot = true;
    private final ReadRowVersionValue readRowVersionValue = new ReadRowVersionValue();
    @Nullable
    private RowVersionReader reader;

    ReadRowVersion(int partitionId) {
        this.partitionId = partitionId;
    }

    @Override
    public long consumePagePayload(long link, long pageAddr, DataPagePayload payload, Predicate<HybridTimestamp> loadValue) {
        if (this.readingFirstSlot) {
            this.readingFirstSlot = false;
            return this.readFullOrInitiateReadFragmented(link, pageAddr, payload, loadValue);
        }
        return this.readRowVersionValue.consumePagePayload(link, pageAddr, payload, null);
    }

    private long readFullOrInitiateReadFragmented(long link, long pageAddr, DataPagePayload payload, Predicate<HybridTimestamp> loadValue) {
        byte dataType = PageUtils.getByte(pageAddr, payload.offset() + 0);
        this.reader = RowVersionReader.newRowVersionReader(dataType, link, this.partitionId);
        this.reader.readFromPage(pageAddr, payload);
        if (!loadValue.test(this.reader.timestamp())) {
            this.result = this.reader.createRowVersion(this.reader.valueSize(), null);
            return 0L;
        }
        return this.readRowVersionValue.consumePagePayload(link, pageAddr, payload, null);
    }

    @Override
    public void finish() {
        if (this.result != null) {
            return;
        }
        assert (this.reader != null);
        this.readRowVersionValue.finish();
        byte[] valueBytes = this.readRowVersionValue.result();
        BinaryRowImpl value = valueBytes.length == 0 ? null : new BinaryRowImpl(this.reader.schemaVersion(), ByteBuffer.wrap(valueBytes).order(BinaryTuple.ORDER));
        int valueSize = value == null ? 0 : value.tupleSliceLength();
        this.result = this.reader.createRowVersion(valueSize, value);
    }

    RowVersion result() {
        return this.result;
    }
}

