/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.pagememory.datapage.PageMemoryTraversal;
import org.apache.ignite3.internal.pagememory.io.DataPagePayload;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.pagememory.util.PageUtils;
import org.apache.ignite3.internal.pagememory.util.PartitionlessLinks;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.storage.pagememory.mv.HybridTimestamps;
import org.apache.ignite3.internal.storage.pagememory.mv.ReadRowVersionValue;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersion;
import org.apache.ignite3.internal.storage.pagememory.mv.RowVersionReader;
import org.jetbrains.annotations.Nullable;

class FindRowVersion
implements PageMemoryTraversal<RowVersionFilter> {
    private final int partitionId;
    private final boolean loadValueBytes;
    private boolean rowVersionFound;
    private final ReadRowVersionValue readRowVersionValue = new ReadRowVersionValue();
    @Nullable
    private RowVersionReader reader;
    @Nullable
    private RowVersion result;

    FindRowVersion(int partitionId, boolean loadValueBytes) {
        this.partitionId = partitionId;
        this.loadValueBytes = loadValueBytes;
    }

    @Override
    public long consumePagePayload(long link, long pageAddr, DataPagePayload payload, RowVersionFilter filter) {
        if (this.rowVersionFound) {
            return this.readRowVersionValue.consumePagePayload(link, pageAddr, payload, null);
        }
        if (!filter.apply(link, pageAddr + (long)payload.offset())) {
            return RowVersion.readNextLink(this.partitionId, pageAddr, payload.offset());
        }
        this.rowVersionFound = true;
        byte dataType = PageUtils.getByte(pageAddr, payload.offset() + 0);
        this.reader = RowVersionReader.newRowVersionReader(dataType, link, this.partitionId);
        this.reader.readFromPage(pageAddr, payload);
        if (this.loadValueBytes) {
            return this.readRowVersionValue.consumePagePayload(link, pageAddr, payload, null);
        }
        return 0L;
    }

    @Override
    public void finish() {
        int valueSize;
        BinaryRowImpl value;
        if (!this.rowVersionFound) {
            return;
        }
        assert (this.reader != null);
        if (this.loadValueBytes) {
            this.readRowVersionValue.finish();
            byte[] valueBytes = this.readRowVersionValue.result();
            value = valueBytes.length == 0 ? null : new BinaryRowImpl(this.reader.schemaVersion(), ByteBuffer.wrap(valueBytes).order(BinaryTuple.ORDER));
            valueSize = value == null ? 0 : value.tupleSliceLength();
        } else {
            value = null;
            valueSize = this.reader.valueSize();
        }
        this.result = this.reader.createRowVersion(valueSize, value);
    }

    @Nullable
    RowVersion getResult() {
        return this.result;
    }

    @FunctionalInterface
    static interface RowVersionFilter {
        public boolean apply(long var1, long var3);

        public static RowVersionFilter equalsByTimestamp(@Nullable HybridTimestamp timestamp) {
            return (rowVersionLink, rowVersionAddr) -> {
                HybridTimestamp readTimestamp = HybridTimestamps.readTimestamp(rowVersionAddr, 1);
                return Objects.equals(timestamp, readTimestamp);
            };
        }

        public static RowVersionFilter equalsByNextLink(long nextLink) {
            return (rowVersionLink, rowVersionAddr) -> {
                long readNextLink = PartitionlessLinks.readPartitionless(PageIdUtils.partitionIdFromLink(rowVersionLink), rowVersionAddr, 9);
                return readNextLink == nextLink;
            };
        }
    }
}

