/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.index;

import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.pagememory.datastructure.DataStructure;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.pagememory.tree.BplusTree;
import org.apache.ignite3.internal.pagememory.util.GradualTask;
import org.apache.ignite3.internal.pagememory.util.GradualTaskExecutor;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.storage.index.PeekCursor;
import org.apache.ignite3.internal.storage.pagememory.index.common.IndexRowKey;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMeta;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaKey;
import org.apache.ignite3.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite3.internal.storage.pagememory.index.meta.UpdateLastRowIdUuidToBuildInvokeClosure;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPageMemoryIndexStorage<K extends IndexRowKey, V extends K, TreeT extends BplusTree<K, V>>
implements IndexStorage {
    protected final int partitionId;
    protected final RowId lowestRowId;
    protected final RowId highestRowId;
    protected final AtomicReference<StorageState> state = new AtomicReference<StorageState>(StorageState.RUNNABLE);
    private volatile IndexMetaTree indexMetaTree;
    protected volatile FreeListImpl freeList;
    protected volatile TreeT indexTree;
    @Nullable
    private volatile RowId nextRowIdToBuild;
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final int indexId;
    private final boolean isVolatile;
    private static final IndexRowKey NO_INDEX_ROW = () -> null;

    protected AbstractPageMemoryIndexStorage(IndexMeta indexMeta, int partitionId, TreeT indexTree, FreeListImpl freeList, IndexMetaTree indexMetaTree, boolean isVolatile) {
        this.indexId = indexMeta.indexId();
        this.partitionId = partitionId;
        this.indexTree = indexTree;
        this.freeList = freeList;
        this.indexMetaTree = indexMetaTree;
        this.isVolatile = isVolatile;
        this.lowestRowId = RowId.lowestRowId(partitionId);
        this.highestRowId = RowId.highestRowId(partitionId);
        this.nextRowIdToBuild = this.getNextRowIdToBuild(indexMeta);
    }

    @Nullable
    public K getRandomRow() {
        return (K)this.busyDataRead(() -> {
            try {
                return (IndexRowKey)((BplusTree)this.indexTree).findRandom();
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Error while advancing the cursor", (Throwable)e);
            }
        });
    }

    @Nullable
    private RowId getNextRowIdToBuild(IndexMeta indexMeta) {
        UUID uuid = indexMeta.nextRowIdUuidToBuild();
        return uuid == null ? null : new RowId(this.partitionId, uuid);
    }

    @Override
    @Nullable
    public RowId getNextRowIdToBuild() {
        return this.busyNonDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance(this.state.get(), this::createStorageInfo);
            return this.nextRowIdToBuild;
        });
    }

    @Override
    public void setNextRowIdToBuild(@Nullable RowId rowId) {
        this.busyNonDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance(this.state.get(), this::createStorageInfo);
            UUID rowIdUuid = rowId == null ? null : rowId.uuid();
            try {
                this.indexMetaTree.invoke(new IndexMetaKey(this.indexId), null, new UpdateLastRowIdUuidToBuildInvokeClosure(rowIdUuid));
            }
            catch (IgniteInternalCheckedException e) {
                throw new StorageException("Error updating last row ID uuid to build: [{}, rowId={}]", (Throwable)e, this.createStorageInfo(), rowId);
            }
            this.nextRowIdToBuild = rowId;
            return null;
        });
    }

    public void close() {
        if (!StorageUtils.transitionToClosedState(this.state, this::createStorageInfo)) {
            return;
        }
        this.busyLock.block();
        this.closeStructures();
    }

    public void startRebalance() {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.REBALANCE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance(this.state.get(), this.createStorageInfo());
        }
        this.busyLock.block();
        try {
            this.closeStructures();
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void completeRebalance() {
        if (!this.state.compareAndSet(StorageState.REBALANCE, StorageState.RUNNABLE)) {
            StorageUtils.throwExceptionDependingOnStorageStateOnRebalance(this.state.get(), this.createStorageInfo());
        }
    }

    public void startCleanup() {
        if (!this.state.compareAndSet(StorageState.RUNNABLE, StorageState.CLEANUP)) {
            StorageUtils.throwExceptionDependingOnStorageState(this.state.get(), this.createStorageInfo());
        }
        this.busyLock.block();
        try {
            this.closeStructures();
        }
        finally {
            this.busyLock.unblock();
        }
    }

    public void finishCleanup() {
        this.state.compareAndSet(StorageState.CLEANUP, StorageState.RUNNABLE);
    }

    public final CompletableFuture<Void> startDestructionOn(GradualTaskExecutor executor) throws StorageException {
        try {
            int maxWorkUnits = this.isVolatile ? 1000 : 1000;
            return executor.execute(this.createDestructionTask(maxWorkUnits));
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Unable to destroy index " + this.indexId, (Throwable)e);
        }
    }

    public boolean transitionToDestroyedState() {
        if (!StorageUtils.transitionToDestroyedState(this.state)) {
            return false;
        }
        this.busyLock.block();
        return true;
    }

    protected abstract GradualTask createDestructionTask(int var1) throws IgniteInternalCheckedException;

    protected String createStorageInfo() {
        return IgniteStringFormatter.format("indexId={}, partitionId={}", this.indexId, this.partitionId);
    }

    public void closeStructures() {
        ((DataStructure)this.indexTree).close();
        this.nextRowIdToBuild = null;
    }

    public void updateDataStructures(IndexMetaTree indexMetaTree, FreeListImpl freeList, TreeT indexTree) {
        StorageUtils.throwExceptionIfStorageNotInCleanupOrRebalancedState(this.state.get(), this::createStorageInfo);
        this.indexMetaTree = indexMetaTree;
        this.freeList = freeList;
        this.indexTree = indexTree;
        try {
            IndexMeta indexMeta = (IndexMeta)indexMetaTree.findOne(new IndexMetaKey(this.indexId), null);
            assert (indexMeta != null) : this.indexId;
            this.nextRowIdToBuild = this.getNextRowIdToBuild(indexMeta);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error reading next row ID uuid to build: [{}]", (Throwable)e, this.createStorageInfo());
        }
    }

    protected <T> T busyNonDataRead(Supplier<T> supplier) {
        return this.busy(supplier, false);
    }

    protected <T> T busyDataRead(Supplier<T> supplier) {
        return this.busy(supplier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T busy(Supplier<T> supplier, boolean read) {
        if (!this.busyLock.enterBusy()) {
            StorageUtils.throwExceptionDependingOnIndexStorageState(this.state.get(), read, this.createStorageInfo());
        }
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    protected void throwExceptionIfIndexIsNotBuilt() {
        StorageUtils.throwExceptionIfIndexIsNotBuilt(this.nextRowIdToBuild, this::createStorageInfo);
    }

    protected abstract class ReadOnlyScanCursor<E, R>
    implements Cursor<R> {
        private final Cursor<E> treeCursor;

        protected ReadOnlyScanCursor(Cursor<E> treeCursor) {
            this.treeCursor = treeCursor;
        }

        protected abstract R map(E var1);

        @Override
        public boolean hasNext() {
            return AbstractPageMemoryIndexStorage.this.busyDataRead(() -> {
                StorageUtils.throwExceptionIfStorageInProgressOfRebalance(AbstractPageMemoryIndexStorage.this.state.get(), AbstractPageMemoryIndexStorage.this::createStorageInfo);
                return this.treeCursor.hasNext();
            });
        }

        @Override
        public R next() {
            return (R)AbstractPageMemoryIndexStorage.this.busyDataRead(() -> {
                StorageUtils.throwExceptionIfStorageInProgressOfRebalance(AbstractPageMemoryIndexStorage.this.state.get(), AbstractPageMemoryIndexStorage.this::createStorageInfo);
                return this.map(this.treeCursor.next());
            });
        }

        @Override
        public void close() {
            this.treeCursor.close();
        }
    }

    protected static abstract class ScanCursor<R>
    implements PeekCursor<R> {
        protected final TreeT localTree;
        @Nullable
        private final K lower;
        @Nullable
        private Boolean hasNext;
        @Nullable
        private V treeRow;
        @Nullable
        private V peekedRow;
        final /* synthetic */ AbstractPageMemoryIndexStorage this$0;

        protected ScanCursor(K lower) {
            this.this$0 = this$0;
            this.localTree = this.this$0.indexTree;
            this.peekedRow = NO_INDEX_ROW;
            this.lower = lower;
        }

        protected abstract R map(V var1);

        protected abstract boolean exceedsUpperBound(V var1);

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.this$0.busyDataRead(() -> {
                try {
                    return this.advanceIfNeededBusy();
                }
                catch (IgniteInternalCheckedException e) {
                    throw new StorageException("Error while advancing the cursor", (Throwable)e);
                }
            });
        }

        @Override
        public R next() {
            return (R)this.this$0.busyDataRead(() -> {
                try {
                    if (!this.advanceIfNeededBusy()) {
                        throw new NoSuchElementException();
                    }
                    this.hasNext = null;
                    return this.map(this.treeRow);
                }
                catch (IgniteInternalCheckedException e) {
                    throw new StorageException("Error while advancing the cursor", (Throwable)e);
                }
            });
        }

        @Override
        @Nullable
        public R peek() {
            return (R)this.this$0.busyDataRead(() -> {
                StorageUtils.throwExceptionIfStorageInProgressOfRebalance(this.this$0.state.get(), this.this$0::createStorageInfo);
                try {
                    return this.map(this.peekBusy());
                }
                catch (IgniteInternalCheckedException e) {
                    throw new StorageException("Error when peeking next element", (Throwable)e);
                }
            });
        }

        @Nullable
        private V peekBusy() throws IgniteInternalCheckedException {
            if (this.hasNext != null) {
                return this.treeRow;
            }
            this.peekedRow = this.treeRow == null ? (this.lower == null ? (IndexRowKey)((BplusTree)this.localTree).findFirst() : (IndexRowKey)((BplusTree)this.localTree).findNext(this.lower, true)) : (IndexRowKey)((BplusTree)this.localTree).findNext(this.treeRow, false);
            if (this.peekedRow != null && this.exceedsUpperBound(this.peekedRow)) {
                this.peekedRow = null;
            }
            return this.peekedRow;
        }

        private boolean advanceIfNeededBusy() throws IgniteInternalCheckedException {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance(this.this$0.state.get(), this.this$0::createStorageInfo);
            if (this.hasNext != null) {
                return this.hasNext;
            }
            this.treeRow = this.peekedRow == NO_INDEX_ROW ? this.peekBusy() : this.peekedRow;
            this.peekedRow = NO_INDEX_ROW;
            this.hasNext = this.treeRow != null;
            return this.hasNext;
        }
    }
}

