/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.configuration;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.ignite3.configuration.ConfigurationModule;
import org.apache.ignite3.configuration.NamedListChange;
import org.apache.ignite3.configuration.SuperRootChange;
import org.apache.ignite3.configuration.annotation.ConfigurationType;
import org.apache.ignite3.internal.storage.configurations.StorageExtensionChange;
import org.apache.ignite3.internal.storage.configurations.StorageExtensionConfiguration;
import org.apache.ignite3.internal.storage.configurations.StorageProfileChange;
import org.apache.ignite3.internal.storage.configurations.StorageProfileView;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.PersistentPageMemoryProfileChange;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.PersistentPageMemoryProfileConfigurationSchema;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineExtensionConfigurationSchema;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.VolatilePageMemoryProfileConfigurationSchema;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.VolatilePageMemoryStorageEngineExtensionConfigurationSchema;

@AutoService(value={ConfigurationModule.class})
public class PageMemoryStorageEngineLocalConfigurationModule
implements ConfigurationModule {
    public static final String DEFAULT_PROFILE_NAME = "default";

    @Override
    public ConfigurationType type() {
        return ConfigurationType.LOCAL;
    }

    @Override
    public Collection<Class<?>> polymorphicSchemaExtensions() {
        return List.of(VolatilePageMemoryProfileConfigurationSchema.class, PersistentPageMemoryProfileConfigurationSchema.class);
    }

    @Override
    public Collection<Class<?>> schemaExtensions() {
        return List.of(PersistentPageMemoryStorageEngineExtensionConfigurationSchema.class, VolatilePageMemoryStorageEngineExtensionConfigurationSchema.class);
    }

    @Override
    public void patchConfigurationWithDynamicDefaults(SuperRootChange rootChange) {
        StorageExtensionChange storageExtensionChange = rootChange.changeRoot(StorageExtensionConfiguration.KEY);
        NamedListChange<StorageProfileView, StorageProfileChange> profiles = storageExtensionChange.changeStorage().changeProfiles();
        if (profiles.get(DEFAULT_PROFILE_NAME) == null) {
            profiles.create(DEFAULT_PROFILE_NAME, profileChange -> profileChange.convert(PersistentPageMemoryProfileChange.class));
        }
    }

    @Override
    public Collection<String> deletedPrefixes() {
        return Set.of("ignite.storage.engines.aipersist.checkpoint.useAsyncFileIoFactory");
    }
}

