/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.sql.fun;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.ignite3.internal.sql.engine.util.IgniteResource;

public class NonNullLiteralOnlyOperandsTypeChecker
implements SqlOperandTypeChecker {
    private final List<SqlTypeFamily> typeFamilies;
    private final SqlOperandCountRange operandCountRange;

    public NonNullLiteralOnlyOperandsTypeChecker(List<SqlTypeFamily> typeFamilies) {
        this.typeFamilies = typeFamilies;
        this.operandCountRange = SqlOperandCountRanges.of((int)typeFamilies.size());
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        int i;
        if (this.typeFamilies.size() != callBinding.getOperandCount()) {
            return false;
        }
        for (i = 0; i < callBinding.getOperandCount(); ++i) {
            RelDataType operandType = callBinding.getOperandType(i);
            SqlTypeFamily typeFamily = this.typeFamilies.get(i);
            if (typeFamily.contains(operandType)) continue;
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        for (i = 0; i < callBinding.getOperandCount(); ++i) {
            SqlNode operand = callBinding.operand(i);
            if (SqlUtil.isLiteral((SqlNode)operand) && !SqlUtil.isNullLiteral((SqlNode)operand, (boolean)false)) continue;
            if (throwOnFailure) {
                SqlValidator validator = callBinding.getValidator();
                String callSignature = NonNullLiteralOnlyOperandsTypeChecker.getCallSignatureWithLiterals(callBinding);
                String operatorName = callBinding.getOperator().getName();
                throw validator.newValidationError(operand, IgniteResource.INSTANCE.argumentsMustBeLiteral(operatorName, callSignature));
            }
            return false;
        }
        return true;
    }

    public SqlOperandCountRange getOperandCountRange() {
        return this.operandCountRange;
    }

    public String getAllowedSignatures(SqlOperator op, String opName) {
        return SqlUtil.getAliasedSignature((SqlOperator)op, (String)opName, this.typeFamilies);
    }

    private static String getCallSignatureWithLiterals(SqlCallBinding callBinding) {
        SqlValidator validator = callBinding.getValidator();
        SqlValidatorScope scope = callBinding.getScope();
        ArrayList<CallSite> typeNames = new ArrayList<CallSite>();
        for (SqlNode operand : callBinding.operands()) {
            RelDataType argType = validator.deriveType(Objects.requireNonNull(scope, "scope"), operand);
            if (argType == null) continue;
            SqlTypeFamily typeFamily = argType.getSqlTypeName().getFamily();
            assert (typeFamily != null);
            if (SqlUtil.isLiteral((SqlNode)operand)) {
                typeNames.add((CallSite)((Object)(typeFamily + " literal")));
                continue;
            }
            typeNames.add((CallSite)((Object)(typeFamily + " non-literal")));
        }
        return SqlUtil.getOperatorSignature((SqlOperator)callBinding.getOperator(), typeNames);
    }
}

