/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.schema;

import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSequence;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.IgniteResource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IgniteSequenceImpl
implements IgniteSequence {
    private final String name;
    private final int version;
    private final int sequenceId;
    private final int tableId;
    private final long increment;
    private final long minValue;
    private final long maxValue;
    private final long start;
    private final long cacheValue;
    private final TableDescriptor desc;

    public IgniteSequenceImpl(String name, int version, int sequenceId, int tableId, long increment, long minValue, long maxValue, long start, long cacheValue, TableDescriptor desc) {
        this.name = name;
        this.version = version;
        this.sequenceId = sequenceId;
        this.tableId = tableId;
        this.increment = increment;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.start = start;
        this.cacheValue = cacheValue;
        this.desc = desc;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int version() {
        return this.version;
    }

    @Override
    public int id() {
        return this.sequenceId;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public long increment() {
        return this.increment;
    }

    @Override
    public long minValue() {
        return this.minValue;
    }

    @Override
    public long maxValue() {
        return this.maxValue;
    }

    @Override
    public long start() {
        return this.start;
    }

    @Override
    public long cacheValue() {
        return this.cacheValue;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.SEQUENCE;
    }

    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.desc.rowType((IgniteTypeFactory)typeFactory, null);
    }

    public boolean isRolledUp(String column) {
        return false;
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, @Nullable SqlNode parent, @Nullable CalciteConnectionConfig config) {
        return false;
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        throw SqlUtil.newContextException((SqlParserPos)SqlParserPos.ZERO, IgniteResource.INSTANCE.notAtable(this.name()));
    }

    public <C> @Nullable C unwrap(Class<C> cls) {
        if (cls.isInstance(this)) {
            return cls.cast(this);
        }
        if (cls.isInstance(this.desc)) {
            return cls.cast(this.desc);
        }
        return null;
    }
}

