/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.schema;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.sql.engine.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteIndex {
    private final int id;
    private final String name;
    private final IgniteDistribution tableDistribution;
    private final RelCollation collation;
    private final Type type;
    private final boolean primaryKey;
    private RelDataType rowType;

    public IgniteIndex(int id, String name, Type type, IgniteDistribution tableDistribution, RelCollation collation) {
        this(id, name, type, tableDistribution, collation, false);
    }

    public IgniteIndex(int id, String name, Type type, IgniteDistribution tableDistribution, RelCollation collation, boolean primaryKey) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.tableDistribution = tableDistribution;
        this.collation = collation;
        this.primaryKey = primaryKey;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public RelCollation collation() {
        return this.collation;
    }

    public boolean primaryKey() {
        return this.primaryKey;
    }

    public RelDataType rowType(IgniteTypeFactory factory, TableDescriptor tableDescriptor) {
        if (this.rowType == null) {
            this.rowType = IgniteIndex.createRowType(factory, tableDescriptor, this.collation);
        }
        return this.rowType;
    }

    public IgniteLogicalIndexScan toRel(RelOptCluster cluster, RelOptTable relOptTable, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode condition, @Nullable ImmutableIntList requiredCols) {
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.Impl.NONE).replace((RelTrait)this.tableDistribution).replace((RelTrait)(this.type() == Type.HASH ? RelCollations.EMPTY : this.collation));
        return IgniteLogicalIndexScan.create(cluster, traitSet, relOptTable, this.name, names, proj, condition, requiredCols);
    }

    static RelCollation createIndexCollation(CatalogIndexDescriptor descriptor, CatalogTableDescriptor tableDescriptor) {
        if (descriptor instanceof CatalogSortedIndexDescriptor) {
            CatalogSortedIndexDescriptor sortedIndexDescriptor = (CatalogSortedIndexDescriptor)descriptor;
            List<CatalogIndexColumnDescriptor> columns = sortedIndexDescriptor.columns();
            ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>(columns.size());
            for (CatalogIndexColumnDescriptor column : columns) {
                RelFieldCollation fieldCollation;
                int fieldIndex = tableDescriptor.columnIndexById(column.columnId());
                switch (column.collation()) {
                    case ASC_NULLS_FIRST: {
                        fieldCollation = new RelFieldCollation(fieldIndex, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.FIRST);
                        break;
                    }
                    case ASC_NULLS_LAST: {
                        fieldCollation = new RelFieldCollation(fieldIndex, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.LAST);
                        break;
                    }
                    case DESC_NULLS_FIRST: {
                        fieldCollation = new RelFieldCollation(fieldIndex, RelFieldCollation.Direction.DESCENDING, RelFieldCollation.NullDirection.FIRST);
                        break;
                    }
                    case DESC_NULLS_LAST: {
                        fieldCollation = new RelFieldCollation(fieldIndex, RelFieldCollation.Direction.DESCENDING, RelFieldCollation.NullDirection.LAST);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected collation: " + column.collation());
                    }
                }
                fieldCollations.add(fieldCollation);
            }
            return RelCollations.of(fieldCollations);
        }
        if (descriptor instanceof CatalogHashIndexDescriptor) {
            CatalogHashIndexDescriptor hashIndexDescriptor = (CatalogHashIndexDescriptor)descriptor;
            IntList columns = hashIndexDescriptor.columnIds();
            ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>(columns.size());
            IntListIterator intListIterator = columns.iterator();
            while (intListIterator.hasNext()) {
                int columnId = (Integer)intListIterator.next();
                CatalogTableColumnDescriptor tableColumn = tableDescriptor.columnById(columnId);
                int fieldIndex = tableDescriptor.columns().indexOf(tableColumn);
                fieldCollations.add(new RelFieldCollation(fieldIndex, RelFieldCollation.Direction.CLUSTERED, RelFieldCollation.NullDirection.UNSPECIFIED));
            }
            return RelCollations.of(fieldCollations);
        }
        throw new IllegalArgumentException("Unexpected index type: " + descriptor);
    }

    public static RelDataType createRowType(IgniteTypeFactory typeFactory, TableDescriptor tableDescriptor, RelCollation collation) {
        RelDataTypeFactory.Builder b = new RelDataTypeFactory.Builder((RelDataTypeFactory)typeFactory);
        for (RelFieldCollation field : collation.getFieldCollations()) {
            ColumnDescriptor colDesc = tableDescriptor.columnDescriptor(field.getFieldIndex());
            b.add(colDesc.name(), TypeUtils.native2relationalType((RelDataTypeFactory)typeFactory, colDesc.physicalType(), colDesc.nullable()));
        }
        return b.build();
    }

    public static RelCollation createSearchRowCollation(RelCollation indexCollation) {
        List collations = indexCollation.getFieldCollations();
        ArrayList<RelFieldCollation> result = new ArrayList<RelFieldCollation>(collations.size());
        for (int i = 0; i < collations.size(); ++i) {
            result.add(((RelFieldCollation)collations.get(i)).withFieldIndex(i));
        }
        return RelCollations.of(result);
    }

    public static enum Type {
        HASH,
        SORTED;

    }

    public static enum Collation {
        ASC_NULLS_FIRST(true, true),
        ASC_NULLS_LAST(true, false),
        DESC_NULLS_FIRST(false, true),
        DESC_NULLS_LAST(false, false);

        public final boolean asc;
        public final boolean nullsFirst;

        public static Collation of(boolean asc, boolean nullsFirst) {
            return asc ? (nullsFirst ? ASC_NULLS_FIRST : ASC_NULLS_LAST) : (nullsFirst ? DESC_NULLS_FIRST : DESC_NULLS_LAST);
        }

        private Collation(boolean asc, boolean nullsFirst) {
            this.asc = asc;
            this.nullsFirst = nullsFirst;
        }
    }
}

