/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.prepare;

import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlBasicTypeNameSpec;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.NonNullableAccessors;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlNonNullableAccessors;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercionImpl;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteSqlValidator;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.IgniteCustomAssignmentsRules;
import org.apache.ignite3.internal.sql.engine.util.IgniteResource;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteTypeCoercion
extends TypeCoercionImpl {
    private final IgniteTypeFactory typeFactory;

    public IgniteTypeCoercion(RelDataTypeFactory typeFactory, SqlValidator validator) {
        super(typeFactory, validator);
        this.typeFactory = (IgniteTypeFactory)typeFactory;
    }

    public boolean binaryComparisonCoercion(SqlCallBinding binding) {
        RelDataType rightType;
        SqlCall call = binding.getCall();
        if (binding.getOperandCount() != 2 || !SqlKind.BINARY_COMPARISON.contains(call.getKind())) {
            return super.binaryComparisonCoercion(binding);
        }
        RelDataType leftType = binding.getOperandType(0);
        if (!TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this.typeFactory, leftType, rightType = binding.getOperandType(1))) {
            return false;
        }
        this.validateBinaryComparisonCoercion(binding, leftType, rightType, (IgniteSqlValidator)this.validator);
        if (leftType.equals(rightType)) {
            return false;
        }
        RelDataType targetType = this.factory.leastRestrictive(Arrays.asList(leftType, rightType));
        if (targetType == null) {
            return false;
        }
        boolean coerced = false;
        SqlValidatorScope scope = binding.getScope();
        if (!leftType.equals(targetType)) {
            coerced = this.coerceOperandType(scope, call, 0, targetType);
        }
        if (!rightType.equals(targetType)) {
            boolean rightCoerced = this.coerceOperandType(scope, call, 1, targetType);
            coerced = coerced || rightCoerced;
        }
        return coerced;
    }

    public boolean binaryArithmeticCoercion(SqlCallBinding binding) {
        RelDataType rightType;
        if (binding.getOperandCount() != 2) {
            return super.binaryComparisonCoercion(binding);
        }
        RelDataType leftType = binding.getOperandType(0);
        if (!TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this.typeFactory, leftType, rightType = binding.getOperandType(1))) {
            return false;
        }
        return super.binaryArithmeticCoercion(binding);
    }

    public boolean builtinFunctionCoercion(SqlCallBinding binding, List<RelDataType> operandTypes, List<SqlTypeFamily> expectedFamilies) {
        boolean typesAreCompatible;
        block4: {
            block3: {
                RelDataType rightType;
                this.validateFunctionOperands(binding, operandTypes, expectedFamilies);
                typesAreCompatible = true;
                if (binding.getOperandCount() != 2 || !SqlKind.BINARY_ARITHMETIC.contains(binding.getCall().getKind())) break block3;
                RelDataType leftType = binding.getOperandType(0);
                if (TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this.typeFactory, leftType, rightType = binding.getOperandType(1))) break block4;
                typesAreCompatible = false;
                break block4;
            }
            assert (operandTypes.size() == expectedFamilies.size());
            for (int i = 0; i < operandTypes.size(); ++i) {
                RelDataType typeFromExpectedFamily = expectedFamilies.get(i).getDefaultConcreteType((RelDataTypeFactory)this.typeFactory);
                if (typeFromExpectedFamily == null || TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this.typeFactory, typeFromExpectedFamily, operandTypes.get(i))) continue;
                typesAreCompatible = false;
                break;
            }
        }
        if (!typesAreCompatible) {
            return false;
        }
        return super.builtinFunctionCoercion(binding, operandTypes, expectedFamilies);
    }

    public boolean inOperationCoercion(SqlCallBinding binding) {
        RelDataType rightRowType;
        SqlOperator operator = binding.getOperator();
        if (!IgniteTypeCoercion.operatorIsInOrQuantify(operator)) {
            return false;
        }
        assert (binding.getOperandCount() == 2);
        RelDataType type1 = binding.getOperandType(0);
        RelDataType type2 = binding.getOperandType(1);
        RelDataType leftRowType = SqlTypeUtil.promoteToRowType((RelDataTypeFactory)this.typeFactory, (RelDataType)type1, null);
        if (!TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this.typeFactory, leftRowType, rightRowType = SqlTypeUtil.promoteToRowType((RelDataTypeFactory)this.typeFactory, (RelDataType)type2, null))) {
            return false;
        }
        if (IgniteTypeCoercion.operatorIsQuantify(operator)) {
            return this.inOperationCoercionFixed(binding);
        }
        return super.inOperationCoercion(binding);
    }

    private static boolean operatorIsIn(SqlOperator operator) {
        return operator.getKind().belongsTo(Set.of(SqlKind.IN, SqlKind.NOT_IN));
    }

    private static boolean operatorIsQuantify(SqlOperator operator) {
        return operator.getKind().belongsTo(Set.of(SqlKind.SOME, SqlKind.ALL));
    }

    private static boolean operatorIsInOrQuantify(SqlOperator operator) {
        return IgniteTypeCoercion.operatorIsIn(operator) || IgniteTypeCoercion.operatorIsQuantify(operator);
    }

    private boolean inOperationCoercionFixed(SqlCallBinding binding) {
        int i;
        assert (IgniteTypeCoercion.operatorIsQuantify(binding.getOperator()));
        assert (binding.getOperandCount() == 2);
        RelDataType type1 = binding.getOperandType(0);
        RelDataType type2 = binding.getOperandType(1);
        SqlNode node1 = binding.operand(0);
        SqlNode node2 = binding.operand(1);
        SqlValidatorScope scope = binding.getScope();
        if (type1.isStruct() && type2.isStruct() && type1.getFieldCount() != type2.getFieldCount()) {
            return false;
        }
        int colCount = type1.isStruct() ? type1.getFieldCount() : 1;
        final RelDataType[] argTypes = new RelDataType[]{type1, type2};
        boolean coerced = false;
        ArrayList<RelDataType> widenTypes = new ArrayList<RelDataType>();
        for (i = 0; i < colCount; ++i) {
            final int i2 = i;
            AbstractList<RelDataType> columnIthTypes = new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return argTypes[index].isStruct() ? ((RelDataTypeField)argTypes[index].getFieldList().get(i2)).getType() : argTypes[index];
                }

                @Override
                public int size() {
                    return argTypes.length;
                }
            };
            RelDataType widenType = this.commonTypeForBinaryComparison((RelDataType)columnIthTypes.get(0), (RelDataType)columnIthTypes.get(1));
            if (widenType == null) {
                widenType = this.getTightestCommonType((RelDataType)columnIthTypes.get(0), (RelDataType)columnIthTypes.get(1));
            }
            if (widenType == null) {
                return false;
            }
            widenTypes.add(widenType);
        }
        assert (widenTypes.size() == colCount);
        for (i = 0; i < widenTypes.size(); ++i) {
            RelDataType desired = (RelDataType)widenTypes.get(i);
            if (node1.getKind() == SqlKind.ROW) {
                assert (node1 instanceof SqlCall);
                if (this.coerceOperandType(scope, (SqlCall)node1, i, desired)) {
                    this.updateInferredColumnType(Objects.requireNonNull(scope, "scope"), node1, i, (RelDataType)widenTypes.get(i));
                    coerced = true;
                }
            } else {
                boolean bl = coerced = this.coerceOperandType(scope, binding.getCall(), 0, desired) || coerced;
            }
            if (node2 instanceof SqlNodeList) {
                SqlNodeList node3 = (SqlNodeList)node2;
                boolean listCoerced = false;
                if (type2.isStruct()) {
                    for (SqlNode node : (SqlNodeList)node2) {
                        assert (node instanceof SqlCall);
                        listCoerced = this.coerceOperandType(scope, (SqlCall)node, i, desired) || listCoerced;
                    }
                    if (listCoerced) {
                        this.updateInferredColumnType(Objects.requireNonNull(scope, "scope"), node2, i, desired);
                    }
                } else {
                    for (int j = 0; j < ((SqlNodeList)node2).size(); ++j) {
                        listCoerced = this.coerceColumnType(scope, node3, j, desired) || listCoerced;
                    }
                    if (listCoerced) {
                        this.updateInferredType(node2, desired);
                    }
                }
                coerced = coerced || listCoerced;
                continue;
            }
            SqlValidatorScope scope1 = node2 instanceof SqlSelect ? this.validator.getSelectScope((SqlSelect)node2) : scope;
            coerced = this.rowTypeCoercion(scope1, node2, i, desired) || coerced;
        }
        return coerced;
    }

    public boolean caseWhenCoercion(SqlCallBinding callBinding) {
        SqlValidatorScope scope = SqlNonNullableAccessors.getScope((SqlCallBinding)callBinding);
        SqlCase caseCall = (SqlCase)callBinding.getCall();
        SqlNodeList thenList = caseCall.getThenOperands();
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        for (SqlNode node : thenList) {
            RelDataType type = this.validator.deriveType(scope, node);
            types.add(type);
        }
        SqlNode elseOp = Objects.requireNonNull(caseCall.getElseOperand(), () -> "getElseOperand() is null for " + caseCall);
        RelDataType elseOpType = this.validator.deriveType(scope, elseOp);
        types.add(elseOpType);
        if (!TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this.typeFactory, types)) {
            return false;
        }
        return super.caseWhenCoercion(callBinding);
    }

    public boolean querySourceCoercion(@Nullable SqlValidatorScope scope, RelDataType sourceRowType, RelDataType targetRowType, SqlNode query) {
        RelDataType targetType;
        if (sourceRowType.getFieldCount() != targetRowType.getFieldCount()) {
            return false;
        }
        for (int i = 0; i < targetRowType.getFieldCount(); ++i) {
            RelDataType targetField;
            RelDataType sourceField = ((RelDataTypeField)sourceRowType.getFieldList().get(i)).getType();
            if (TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this.typeFactory, sourceField, targetField = ((RelDataTypeField)targetRowType.getFieldList().get(i)).getType())) continue;
            return false;
        }
        this.validateDynamicParametersInModify(scope, targetRowType, query);
        List sourceFields = sourceRowType.getFieldList();
        List targetFields = targetRowType.getFieldList();
        int sourceCount = sourceFields.size();
        SqlTypeMappingRule mappingRule = this.validator.getTypeMappingRule();
        for (int i = 0; i < sourceCount; ++i) {
            RelDataType sourceType = ((RelDataTypeField)sourceFields.get(i)).getType();
            targetType = ((RelDataTypeField)targetFields.get(i)).getType();
            if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)this.validator.getTypeFactory(), (RelDataType)sourceType, (RelDataType)targetType) || SqlTypeUtil.canCastFrom((RelDataType)targetType, (RelDataType)sourceType, (SqlTypeMappingRule)mappingRule)) continue;
            return false;
        }
        boolean coerced = false;
        for (int i = 0; i < sourceFields.size(); ++i) {
            targetType = ((RelDataTypeField)targetFields.get(i)).getType();
            coerced = this.coerceSourceRowType(scope, query, i, targetType) || coerced;
        }
        return coerced;
    }

    private boolean coerceSourceRowType(@Nullable SqlValidatorScope sourceScope, SqlNode query, int columnIndex, RelDataType targetType) {
        switch (query.getKind()) {
            case INSERT: {
                SqlInsert insert = (SqlInsert)query;
                return this.coerceSourceRowType(sourceScope, insert.getSource(), columnIndex, targetType);
            }
            case UPDATE: {
                SqlUpdate update = (SqlUpdate)query;
                SqlSelect select = (SqlSelect)Nullness.castNonNull((Object)update.getSourceSelect());
                return this.coerceSourceRowType(sourceScope, (SqlNode)select, columnIndex += select.getSelectList().size() - update.getTargetColumnList().size(), targetType);
            }
        }
        return this.rowTypeCoercion(sourceScope, query, columnIndex, targetType);
    }

    @Nullable
    public RelDataType getWiderTypeFor(List<RelDataType> typeList, boolean stringPromotion) {
        if (!TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this.typeFactory, typeList)) {
            return null;
        }
        return super.getWiderTypeFor(typeList, stringPromotion);
    }

    protected boolean needToCast(SqlValidatorScope scope, SqlNode node, RelDataType toType) {
        RelDataType fromType = this.validator.deriveType(scope, node);
        if (SqlTypeUtil.isCharacter((RelDataType)toType) && SqlTypeUtil.isCharacter((RelDataType)fromType)) {
            return false;
        }
        if (SqlTypeUtil.equalSansNullability((RelDataTypeFactory)this.typeFactory, (RelDataType)fromType, (RelDataType)toType)) {
            return false;
        }
        if (SqlTypeUtil.isBinary((RelDataType)toType) && SqlTypeUtil.isBinary((RelDataType)fromType)) {
            return false;
        }
        if (SqlTypeUtil.isInterval((RelDataType)toType)) {
            if (SqlTypeUtil.isInterval((RelDataType)fromType)) {
                return fromType.getSqlTypeName().getFamily() != toType.getSqlTypeName().getFamily();
            }
        } else if (SqlTypeUtil.isIntType((RelDataType)toType) ? SqlTypeUtil.isIntType((RelDataType)fromType) && fromType.getSqlTypeName() != toType.getSqlTypeName() : SqlTypeUtil.isNull((RelDataType)fromType)) {
            return true;
        }
        return IgniteCustomAssignmentsRules.instance().canApplyFrom(toType.getSqlTypeName(), fromType.getSqlTypeName());
    }

    protected boolean coerceOperandType(@Nullable SqlValidatorScope scope, SqlCall call, int index, RelDataType targetType) {
        SqlNode operand;
        if (RelDataTypeFactoryImpl.isJavaType((RelDataType)targetType)) {
            targetType = ((JavaTypeFactory)this.factory).toSql(targetType);
        }
        if ((operand = (SqlNode)call.getOperandList().get(index)) instanceof SqlDynamicParam) {
            this.validateOperand((SqlDynamicParam)operand, targetType, call.getOperator(), (IgniteSqlValidator)this.validator);
        }
        if (operand.getKind() == SqlKind.DEFAULT) {
            return false;
        }
        Objects.requireNonNull(scope, "scope");
        RelDataType operandType = this.validator.deriveType(scope, operand);
        if (this.coerceStringToArray(call, operand, index, operandType, targetType).booleanValue()) {
            return true;
        }
        if (!this.needToCast(scope, operand, targetType)) {
            return false;
        }
        RelDataType targetType1 = this.syncAttributes(operandType, targetType);
        SqlNode desired = IgniteTypeCoercion.castTo(operand, targetType1);
        call.setOperand(index, desired);
        this.updateInferredType(desired, targetType1);
        return true;
    }

    protected boolean coerceColumnType(@Nullable SqlValidatorScope scope, SqlNodeList nodeList, int index, RelDataType targetType) {
        if (RelDataTypeFactoryImpl.isJavaType((RelDataType)targetType)) {
            targetType = ((JavaTypeFactory)this.factory).toSql(targetType);
        }
        if (index >= nodeList.size()) {
            return true;
        }
        SqlNode node = nodeList.get(index);
        if (node instanceof SqlIdentifier) {
            SqlIdentifier node1 = (SqlIdentifier)node;
            if (node1.isStar()) {
                return true;
            }
            if (DynamicRecordType.isDynamicStarColName((String)((String)Util.last((List)node1.names)))) {
                return false;
            }
        }
        Objects.requireNonNull(scope, "scope is needed for needToCast(scope, operand, targetType)");
        if (node instanceof SqlCall) {
            SqlCall node2 = (SqlCall)node;
            if (node2.getOperator().kind == SqlKind.AS) {
                SqlNode operand = node2.operand(0);
                if (!this.needToCast(scope, operand, targetType)) {
                    return false;
                }
                RelDataType targetType2 = this.syncAttributes(this.validator.deriveType(scope, operand), targetType);
                SqlNode casted = IgniteTypeCoercion.castTo(operand, targetType2);
                node2.setOperand(0, casted);
                this.updateInferredType(casted, targetType2);
                return true;
            }
        }
        if (!this.needToCast(scope, node, targetType)) {
            return false;
        }
        RelDataType targetType3 = this.syncAttributes(this.validator.deriveType(scope, node), targetType);
        SqlNode node3 = IgniteTypeCoercion.castTo(node, targetType3);
        nodeList.set(index, node3);
        this.updateInferredType(node3, targetType3);
        return true;
    }

    RelDataType syncAttributes(RelDataType fromType, RelDataType toType) {
        RelDataType syncedType = toType;
        if (fromType != null) {
            Charset charset;
            syncedType = this.factory.createTypeWithNullability(syncedType, fromType.isNullable());
            if (SqlTypeUtil.inCharOrBinaryFamilies((RelDataType)fromType) && SqlTypeUtil.inCharOrBinaryFamilies((RelDataType)toType) && (charset = fromType.getCharset()) != null && SqlTypeUtil.inCharFamily((RelDataType)syncedType)) {
                SqlCollation collation = NonNullableAccessors.getCollation((RelDataType)fromType);
                syncedType = this.factory.createTypeWithCharsetAndCollation(syncedType, charset, collation);
            }
        }
        return syncedType;
    }

    @Nullable
    public RelDataType commonTypeForBinaryComparison(@Nullable RelDataType type1, @Nullable RelDataType type2) {
        if (type1 == null || type2 == null) {
            return null;
        }
        SqlTypeName t1 = type1.getSqlTypeName();
        SqlTypeName t2 = type2.getSqlTypeName();
        if (t1 == SqlTypeName.TIMESTAMP && t2 == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE || t1 == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE && t2 == SqlTypeName.TIMESTAMP) {
            return this.typeFactory.leastRestrictive(List.of(type1, type2));
        }
        return super.commonTypeForBinaryComparison(type1, type2);
    }

    private static SqlNode castTo(SqlNode node, RelDataType type) {
        SqlDataTypeSpec targetDataType = type.getSqlTypeName() == SqlTypeName.UUID ? new SqlDataTypeSpec((SqlTypeNameSpec)new SqlBasicTypeNameSpec(SqlTypeName.UUID, SqlParserPos.ZERO), null, Boolean.valueOf(type.isNullable()), SqlParserPos.ZERO) : SqlTypeUtil.convertTypeToSpec((RelDataType)type).withNullable(Boolean.valueOf(type.isNullable()));
        return SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{node, targetDataType});
    }

    private void validateFunctionOperands(SqlCallBinding binding, List<RelDataType> operandTypes, List<SqlTypeFamily> expectedFamilies) {
        IgniteSqlValidator validator = (IgniteSqlValidator)binding.getValidator();
        for (int i = 0; i < binding.getOperandCount(); ++i) {
            SqlTypeFamily expectedTypeFamily;
            SqlNode operand = binding.getCall().operand(i);
            if (!validator.isUnspecifiedDynamicParam(operand) || (expectedTypeFamily = expectedFamilies.get(i)).getTypeNames().size() <= 1) continue;
            String signature = IgniteResource.makeSignature(binding, operandTypes);
            String allowedSignatures = binding.getOperator().getAllowedSignatures();
            throw binding.newValidationError(IgniteResource.INSTANCE.ambiguousOperator2(signature, allowedSignatures));
        }
    }

    private void validateDynamicParametersInModify(@Nullable SqlValidatorScope scope, RelDataType targetRowType, SqlNode query) {
        List<SqlNodeList> sourceLists;
        if (query instanceof SqlInsert) {
            SqlInsert insert = (SqlInsert)query;
            if (insert.getSource() instanceof SqlSelect) {
                SqlSelect sqlSelect = (SqlSelect)insert.getSource();
                sourceLists = List.of(sqlSelect.getSelectList());
            } else {
                SqlCall sqlCall = (SqlCall)insert.getSource();
                assert (sqlCall.getKind() == SqlKind.VALUES) : "Unexpected source node for INSERT " + sqlCall;
                ArrayList<SqlNodeList> rows = new ArrayList<SqlNodeList>(sqlCall.getOperandList().size());
                for (SqlNode rowNode : sqlCall.getOperandList()) {
                    SqlCall row = (SqlCall)rowNode;
                    rows.add((SqlNodeList)row.getOperandList());
                }
                sourceLists = rows;
            }
        } else if (query instanceof SqlUpdate) {
            SqlUpdate update = (SqlUpdate)query;
            sourceLists = List.of(update.getSourceExpressionList());
        } else {
            throw new AssertionError((Object)("Encountered unexpected SQL node during dynamic parameter validation: " + query));
        }
        for (List list : sourceLists) {
            for (int i = 0; i < list.size(); ++i) {
                SqlNode node = (SqlNode)list.get(i);
                if (node.getKind() != SqlKind.DYNAMIC_PARAM) continue;
                boolean insertOp = query instanceof SqlInsert;
                SqlDynamicParam dynamicParam = (SqlDynamicParam)node;
                RelDataType targetType = ((RelDataTypeField)targetRowType.getFieldList().get(i)).getType();
                IgniteSqlValidator validator1 = (IgniteSqlValidator)scope.getValidator();
                this.validateAssignment(dynamicParam, targetType, insertOp, validator1);
            }
        }
    }

    private void validateBinaryComparisonCoercion(SqlCallBinding binding, RelDataType leftType, RelDataType rightType, IgniteSqlValidator validator) {
        RelDataType nullableType;
        SqlNode lhs = binding.operand(0);
        SqlNode rhs = binding.operand(1);
        boolean lhsUnknown = validator.isUnspecifiedDynamicParam(lhs);
        boolean rhsUnknown = validator.isUnspecifiedDynamicParam(rhs);
        if (lhsUnknown && rhsUnknown) {
            String signature = IgniteResource.makeSignature(binding, leftType, rightType);
            throw binding.newValidationError(IgniteResource.INSTANCE.ambiguousOperator1(signature));
        }
        if (lhs instanceof SqlDynamicParam) {
            if (rhsUnknown) {
                nullableType = this.typeFactory.createTypeWithNullability(rightType, true);
                validator.setValidatedNodeType(binding.operand(0), nullableType);
            } else {
                this.validateOperand((SqlDynamicParam)lhs, rightType, binding.getOperator(), validator);
            }
        }
        if (rhs instanceof SqlDynamicParam) {
            if (lhsUnknown) {
                nullableType = this.typeFactory.createTypeWithNullability(leftType, true);
                validator.setValidatedNodeType(binding.operand(1), nullableType);
            } else {
                this.validateOperand((SqlDynamicParam)rhs, leftType, binding.getOperator(), validator);
            }
        }
    }

    private void validateAssignment(SqlDynamicParam node, RelDataType targetType, boolean insertOp, IgniteSqlValidator validator) {
        RelDataType paramType = validator.resolveDynamicParameterType(node, targetType);
        boolean compatible = TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this.typeFactory, targetType, paramType);
        if (compatible) {
            return;
        }
        if (insertOp) {
            Resources.ExInst ex = Static.RESOURCE.incompatibleValueType(SqlStdOperatorTable.VALUES.getName());
            throw SqlUtil.newContextException((SqlParserPos)node.getParserPosition(), (Resources.ExInst)ex);
        }
        String paramTypeString = paramType.toString();
        String targetTypeString = targetType.toString();
        Resources.ExInst<SqlValidatorException> ex = IgniteResource.INSTANCE.assignmentRequiresExplicitCast(paramTypeString, targetTypeString);
        throw SqlUtil.newContextException((SqlParserPos)node.getParserPosition(), ex);
    }

    private void validateOperand(SqlDynamicParam node, RelDataType targetType, SqlOperator operator, IgniteSqlValidator validator) {
        RelDataType paramType = validator.resolveDynamicParameterType(node, targetType);
        boolean compatible = TypeUtils.typeFamiliesAreCompatible((RelDataTypeFactory)this.typeFactory, targetType, paramType);
        if (compatible) {
            return;
        }
        if (validator.isUnspecified(node)) {
            Resources.ExInst<SqlValidatorException> ex = IgniteResource.INSTANCE.ambiguousOperator1(operator.getName());
            throw SqlUtil.newContextException((SqlParserPos)node.getParserPosition(), ex);
        }
        Resources.ExInst<SqlValidatorException> ex = IgniteResource.INSTANCE.operationRequiresExplicitCast(operator.getName());
        throw SqlUtil.newContextException((SqlParserPos)node.getParserPosition(), ex);
    }
}

