/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.metadata;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdSelectivity;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.ExactBounds;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.MultiBounds;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.RangeBounds;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite3.internal.sql.engine.rel.IgniteHashIndexSpool;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSortedIndexSpool;
import org.apache.ignite3.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public class IgniteMdSelectivity
extends RelMdSelectivity {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource((Method)BuiltInMethod.SELECTIVITY.method, (MetadataHandler)new IgniteMdSelectivity());
    public static final double EQ_SELECTIVITY = 0.333;
    public static final double IS_NOT_NULL_SELECTIVITY = 0.9;
    public static final double COMPARISON_SELECTIVITY = 0.5;
    public static final double DEFAULT_SELECTIVITY_INCREMENT = 0.05;
    public static final double DEFAULT_SELECTIVITY = 0.25;

    private static double computeOpsSelectivity(Map<RexNode, List<SqlKind>> operands, double baseSelectivity) {
        double result = baseSelectivity;
        for (Map.Entry<RexNode, List<SqlKind>> e : operands.entrySet()) {
            int eqNum = 0;
            double result0 = 0.0;
            block6: for (SqlKind kind : e.getValue()) {
                switch (kind) {
                    case IS_NOT_NULL: {
                        result0 = Math.max(result0, 0.9);
                        continue block6;
                    }
                    case EQUALS: {
                        result0 = Math.min(result0 + 0.333 / Math.sqrt(++eqNum), 1.0);
                        continue block6;
                    }
                    case GREATER_THAN: 
                    case LESS_THAN: 
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN_OR_EQUAL: {
                        result0 = Math.min(result0 + 0.5, 1.0);
                        continue block6;
                    }
                }
                result0 += 0.05;
            }
            result = Math.max(result, result0);
        }
        return result;
    }

    private static double computeOrSelectivity(RexCall call, @Nullable BitSet primaryKeys, @Nullable Mapping columnMapping) {
        ImmutableList operands = call.operands;
        ArrayList<RexNode> andOperands = new ArrayList<RexNode>();
        ArrayList<RexNode> otherOperands = new ArrayList<RexNode>();
        double baseSelectivity = 0.0;
        HashMap<RexNode, List<SqlKind>> processOperands = new HashMap<RexNode, List<SqlKind>>();
        assert (!operands.isEmpty());
        boolean andConsist = operands.stream().anyMatch(op -> op.isA(SqlKind.AND));
        if (andConsist) {
            for (RexNode op2 : operands) {
                if (op2.isA(SqlKind.AND)) {
                    andOperands.add(op2);
                    continue;
                }
                otherOperands.add(op2);
            }
        }
        for (RexNode andOp : andOperands) {
            baseSelectivity = Math.max(baseSelectivity, IgniteMdSelectivity.guessAndSelectivity(andOp, primaryKeys == null ? null : (BitSet)primaryKeys.clone(), columnMapping));
        }
        List operandsToProcess = andConsist ? otherOperands : call.getOperands();
        for (RexNode node : operandsToProcess) {
            RexLocalRef ref = IgniteMdSelectivity.getLocalRef(node);
            if (ref != null) {
                List vals = processOperands.computeIfAbsent((RexNode)ref, k -> new ArrayList());
                vals.add(node.getKind());
                continue;
            }
            baseSelectivity = Math.max(baseSelectivity, IgniteMdSelectivity.nonColumnRefSelectivity(call));
        }
        return IgniteMdSelectivity.computeOpsSelectivity(processOperands, baseSelectivity);
    }

    private static double nonColumnRefSelectivity(RexCall call) {
        if (call.isA(SqlKind.EQUALS)) {
            return 0.333;
        }
        if (call.isA((Collection)SqlKind.COMPARISON)) {
            return 0.5;
        }
        return 0.0;
    }

    private static RexLocalRef getLocalRef(RexNode node) {
        RexVisitorImpl<Void> v = new RexVisitorImpl<Void>(true){

            public Void visitLocalRef(RexLocalRef locRef) {
                throw new Util.FoundOne((Object)locRef);
            }
        };
        try {
            node.accept((RexVisitor)v);
            return null;
        }
        catch (Util.FoundOne e) {
            return (RexLocalRef)e.getNode();
        }
    }

    private static double guessSelectivity(@Nullable RexNode predicate, ProjectableFilterableTableScan rel) {
        double sel = 1.0;
        if (predicate == null || predicate.isAlwaysTrue()) {
            return sel;
        }
        @Nullable IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        BitSet primaryKeys = null;
        Mappings.IdentityMapping columnMapping = null;
        if (table != null) {
            int colCount = table.getRowType((RelDataTypeFactory)Commons.typeFactory()).getFieldCount();
            columnMapping = rel.requiredColumns() == null ? Mappings.createIdentity((int)colCount) : Commons.projectedMapping(colCount, rel.requiredColumns());
            ImmutableIntList keyColumns = table.keyColumns();
            primaryKeys = new BitSet();
            Iterator iterator = keyColumns.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                primaryKeys.set(i);
            }
        }
        double artificialSel = 1.0;
        List conjunctions = RelOptUtil.conjunctions((RexNode)predicate);
        for (RexNode pred : conjunctions) {
            RexNode predicateExpanded = RexUtil.expandSearch((RexBuilder)Commons.rexBuilder(), null, (RexNode)pred);
            if (predicateExpanded.isA(SqlKind.OR)) {
                double processed = IgniteMdSelectivity.computeOrSelectivity((RexCall)predicateExpanded, primaryKeys == null ? null : (BitSet)primaryKeys.clone(), (Mapping)columnMapping);
                sel *= processed;
                continue;
            }
            sel *= IgniteMdSelectivity.computeSelectivity(predicateExpanded, primaryKeys, (Mapping)columnMapping);
        }
        return sel * artificialSel;
    }

    private static double guessAndSelectivity(@Nullable RexNode predicate, @Nullable BitSet keyColumns, @Nullable Mapping columnMapping) {
        double sel = 1.0;
        if (predicate == null || predicate.isAlwaysTrue()) {
            return sel;
        }
        List conjunctions = RelOptUtil.conjunctions((RexNode)predicate);
        for (RexNode pred : conjunctions) {
            sel *= IgniteMdSelectivity.computeSelectivity(pred, keyColumns, columnMapping);
        }
        return sel;
    }

    private static double computeSelectivity(RexNode predicate, @Nullable BitSet keyColumns, @Nullable Mapping columnMapping) {
        double sel = 1.0;
        double artificialSel = 1.0;
        if (predicate.getKind() == SqlKind.IS_NOT_NULL) {
            sel *= 0.9;
        } else if (predicate instanceof RexCall && ((RexCall)predicate).getOperator() == RelMdUtil.ARTIFICIAL_SELECTIVITY_FUNC) {
            artificialSel *= RelMdUtil.getSelectivityValue((RexNode)predicate);
        } else if (predicate.isA(SqlKind.EQUALS)) {
            if (keyColumns != null) {
                assert (columnMapping != null);
                RexLocalRef localRef = IgniteMdSelectivity.getLocalRef(predicate);
                if (localRef != null) {
                    keyColumns.clear(columnMapping.getSource(localRef.getIndex()));
                    if (keyColumns.isEmpty()) {
                        return 0.0;
                    }
                }
            }
            sel *= 0.333;
        } else {
            sel = predicate.isA((Collection)SqlKind.COMPARISON) ? (sel *= 0.5) : (sel *= 0.25);
        }
        return sel * artificialSel;
    }

    public Double getSelectivity(ProjectableFilterableTableScan rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate == null) {
            return IgniteMdSelectivity.guessSelectivity(rel.condition(), rel);
        }
        RexNode condition = rel.pushUpPredicate();
        if (condition == null) {
            return IgniteMdSelectivity.guessSelectivity(predicate, rel);
        }
        RexNode diff = RelMdUtil.minusPreds((RexBuilder)RexUtils.builder((RelNode)rel), (RexNode)predicate, (RexNode)condition);
        return IgniteMdSelectivity.guessSelectivity(diff, rel);
    }

    public Double getSelectivity(IgniteSortedIndexSpool rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds((RexBuilder)rel.getCluster().getRexBuilder(), (RexNode)predicate, (RexNode)rel.condition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.condition());
    }

    public Double getSelectivity(IgniteHashIndexSpool rel, RelMetadataQuery mq, RexNode predicate) {
        if (predicate != null) {
            return mq.getSelectivity(rel.getInput(), RelMdUtil.minusPreds((RexBuilder)rel.getCluster().getRexBuilder(), (RexNode)predicate, (RexNode)rel.condition()));
        }
        return mq.getSelectivity(rel.getInput(), rel.condition());
    }

    private static double guessCostMultiplier(SearchBounds bounds) {
        if (bounds instanceof ExactBounds) {
            return 0.1;
        }
        if (bounds instanceof RangeBounds) {
            RangeBounds rangeBounds = (RangeBounds)bounds;
            if (rangeBounds.condition() != null) {
                return ((RexCall)rangeBounds.condition()).op.kind == SqlKind.EQUALS ? 0.1 : 0.2;
            }
            return 0.35;
        }
        if (bounds instanceof MultiBounds) {
            MultiBounds multiBounds = (MultiBounds)bounds;
            return multiBounds.bounds().stream().mapToDouble(IgniteMdSelectivity::guessCostMultiplier).max().orElseThrow(AssertionError::new);
        }
        return 1.0;
    }
}

