/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.rel;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.apache.ignite3.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite3.internal.schema.BinaryRowConverter;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.BinaryTupleSchema;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.KeyValueCodec;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.type.NativeType;
import org.apache.ignite3.internal.type.NativeTypes;
import org.apache.ignite3.internal.type.StructNativeType;
import org.jetbrains.annotations.Nullable;

public class SetNodeKeyValueCodec
implements KeyValueCodec<GroupKey, int[]> {
    private final StructNativeType inputSchema;
    private final BinaryTupleSchema.Element[] elements;
    private final int keyNum;
    private final int intRowSize;
    private final Supplier<BinaryTupleBuilder> keyBuilder;

    public SetNodeKeyValueCodec(StructNativeType inputSchema, int keyNum, int intRowSize) {
        this.inputSchema = inputSchema;
        this.keyNum = keyNum;
        this.intRowSize = intRowSize;
        this.elements = new BinaryTupleSchema.Element[keyNum];
        for (int i = 0; i < keyNum; ++i) {
            StructNativeType.Field field = inputSchema.fields().get(i);
            NativeType nativeType = field.type();
            this.elements[i] = nativeType == NativeTypes.NULL ? null : new BinaryTupleSchema.Element(nativeType, field.nullable());
        }
        IntArrayList keys = new IntArrayList(keyNum);
        IntStream.range(0, keyNum).forEach(arg_0 -> ((IntList)keys).add(arg_0));
        this.keyBuilder = KeyValueCodec.createBinaryTupleBuilder(inputSchema, (IntList)keys);
    }

    @Override
    public BinaryTuple encodeKey(GroupKey key) {
        BinaryTupleBuilder builder = this.keyBuilder.get();
        for (int i = 0; i < this.keyNum; ++i) {
            BinaryTupleSchema.Element element = this.elements[i];
            Object internal = key.field(i);
            if (element == null || internal == null) {
                builder.appendNull();
                continue;
            }
            Object val = TypeUtils.fromInternal(internal, element.typeSpec());
            assert (val != null);
            BinaryRowConverter.appendValue(builder, element, val);
        }
        return new BinaryTuple(this.keyNum, builder.build());
    }

    @Override
    public GroupKey decodeKey(BinaryTuple key) {
        GroupKey.Builder groupKey = GroupKey.builder(this.keyNum);
        for (int i = 0; i < this.keyNum; ++i) {
            StructNativeType.Field field = this.inputSchema.fields().get(i);
            NativeType nativeType = field.type();
            if (nativeType == NativeTypes.NULL) {
                groupKey.add(null);
                continue;
            }
            Object val = Commons.readValue(key, nativeType, i);
            Object internal = val == null ? val : TypeUtils.toInternal(val, nativeType.spec());
            groupKey.add(internal);
        }
        return groupKey.build();
    }

    @Override
    @Nullable
    public ByteBuffer encodeValue(int[] val, ByteBuffer buf) {
        for (int i = 0; i < this.intRowSize; ++i) {
            buf.putInt(val[i]);
        }
        return null;
    }

    @Override
    public int[] decodeValue(ByteBuffer buf) {
        int[] ints = new int[this.intRowSize];
        for (int i = 0; i < this.intRowSize; ++i) {
            ints[i] = buf.getInt();
        }
        return ints;
    }

    @Override
    public int initialValueSizeInBytes() {
        return 4 * this.intRowSize;
    }
}

