/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.query;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.sql.engine.InternalSqlRow;
import org.apache.ignite3.internal.sql.engine.exec.LifecycleAware;
import org.apache.ignite3.internal.sql.engine.exec.query.CopyHandlerModule;
import org.apache.ignite3.internal.sql.engine.prepare.copy.CopyCommand;
import org.apache.ignite3.internal.table.distributed.TableManager;
import org.apache.ignite3.lang.ErrorGroups;
import org.gridgain.internal.license.LicenseFeature;
import org.gridgain.internal.license.LicenseFeatureChecker;
import org.jetbrains.annotations.Nullable;

public class CopyHandler
implements LifecycleAware {
    private final String nodeName;
    private final TableManager tableManager;
    private final LicenseFeatureChecker licenseChecker;
    @Nullable
    private CopyHandlerModule copy;

    public CopyHandler(String nodeName, TableManager tableManager, LicenseFeatureChecker licenseChecker) {
        this.nodeName = nodeName;
        this.tableManager = tableManager;
        this.licenseChecker = licenseChecker;
    }

    @Override
    public void start() {
        this.copy = CopyHandler.loadFromServiceLoader();
    }

    @Override
    public void stop() throws Exception {
        if (this.copy != null) {
            this.copy.close();
        }
    }

    public CompletableFuture<Iterator<InternalSqlRow>> handle(CopyCommand command) {
        try {
            this.licenseChecker.checkFeature(LicenseFeature.SQL_COPY);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        if (this.copy != null) {
            return this.copy.handle(this.nodeName, this.tableManager, command);
        }
        return CompletableFuture.failedFuture(new IgniteInternalCheckedException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported COPY command [cmdName=" + (command == null ? null : command.getClass().getSimpleName()) + "; cmd=\"" + command + "\"]"));
    }

    @Nullable
    private static CopyHandlerModule loadFromServiceLoader() {
        Iterator<CopyHandlerModule> it = ServiceLoader.load(CopyHandlerModule.class).iterator();
        return it.hasNext() ? it.next() : null;
    }
}

