/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory.structures.inmemory;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowQueue;
import org.apache.ignite3.sql.SqlException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
class RowQueueImpl<RowT>
implements RowQueue<RowT> {
    protected final MemoryContext<RowT> memoryContext;
    protected Queue<RowT> delegate;

    RowQueueImpl(MemoryContext<RowT> memoryContext, int numElements) {
        this(memoryContext, new ArrayDeque(numElements));
    }

    RowQueueImpl(MemoryContext<RowT> memoryContext, Queue<RowT> delegate) {
        this.memoryContext = memoryContext;
        this.delegate = delegate;
    }

    @Override
    public void add(RowT element) {
        this.checkClosed();
        Objects.requireNonNull(element, "element");
        this.memoryContext.acquire(element);
        this.delegate.add(element);
    }

    @Override
    @Nullable
    public RowT peek() {
        this.checkClosed();
        return this.delegate.peek();
    }

    @Override
    @Nullable
    public RowT poll() {
        this.checkClosed();
        RowT element = this.delegate.poll();
        if (element != null) {
            this.memoryContext.release(element);
        }
        return element;
    }

    @Override
    public RowT remove() {
        this.checkClosed();
        RowT element = this.delegate.remove();
        this.memoryContext.release(element);
        return element;
    }

    @Override
    public int size() {
        this.checkClosed();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkClosed();
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<RowT> iterator() {
        this.checkClosed();
        return new ReadOnlyIterator(this.delegate.iterator());
    }

    @Override
    public void clear() {
        this.checkClosed();
        this.memoryContext.release((Iterable<RowT>)this.delegate);
        this.delegate.clear();
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.memoryContext.release((Iterable<RowT>)this.delegate);
        }
        this.delegate = null;
    }

    protected void checkClosed() {
        if (this.delegate == null) {
            throw new SqlException(GridgainErrorGroups.MemoryQuota.SPILLING_ERR, "Queue row store is closed.");
        }
    }

    class ReadOnlyIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> iterator;

        public ReadOnlyIterator(Iterator<? extends T> iterator) {
            this.iterator = Objects.requireNonNull(iterator, "iterator");
        }

        @Override
        public boolean hasNext() {
            RowQueueImpl.this.checkClosed();
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            RowQueueImpl.this.checkClosed();
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

