/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.memory;

import org.apache.ignite3.internal.sql.engine.exec.ExecutionId;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContextFactory;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryContextProvider;
import org.apache.ignite3.internal.sql.engine.exec.memory.MemoryTrackingStrategy;
import org.apache.ignite3.internal.sql.engine.exec.memory.NoOpMemoryContext;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.RowStorageFactory;
import org.apache.ignite3.internal.sql.engine.exec.memory.structures.inmemory.RowStorageFactoryImpl;

class DisabledMemoryTrackingStrategy<RowT>
extends MemoryTrackingStrategy<RowT> {
    DisabledMemoryTrackingStrategy() {
    }

    @Override
    MemoryContextFactory<RowT> newFragmentMemoryContextFactory() {
        return new DisabledMemoryContextFactory();
    }

    @Override
    boolean memoryQuotaEnabled() {
        return false;
    }

    @Override
    public long reserved() {
        return 0L;
    }

    @Override
    public long maxReserved() {
        return 0L;
    }

    @Override
    boolean offloadingEnabled() {
        return false;
    }

    @Override
    public long offloaded() {
        return 0L;
    }

    @Override
    public long maxOffloaded() {
        return 0L;
    }

    @Override
    public int openFiles() {
        return 0;
    }

    @Override
    public long reads() {
        return 0L;
    }

    @Override
    public long writes() {
        return 0L;
    }

    @Override
    public long bytesRead() {
        return 0L;
    }

    @Override
    public long bytesWritten() {
        return 0L;
    }

    @Override
    public int offloadedActiveQueries() {
        return 0;
    }

    @Override
    public long offloadedQueries() {
        return 0L;
    }

    private static class DisabledMemoryContextFactory<RowT>
    implements MemoryContextFactory<RowT> {
        private DisabledMemoryContextFactory() {
        }

        @Override
        public MemoryContextProvider<RowT> createMemoryContextProvider() {
            return new MemoryContextProvider<RowT>(){

                @Override
                public MemoryContext<RowT> create() {
                    return NoOpMemoryContext.instance();
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public RowStorageFactory<RowT> createRowStorageFactory(MemoryContext<RowT> memoryContext, ExecutionId executionId, long fragmentId) {
            return new RowStorageFactoryImpl<RowT>(memoryContext);
        }
    }
}

