/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.exp;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.zone.ZoneRules;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.function.NonDeterministic;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.schema.SchemaUtils;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.IgniteMath;
import org.apache.ignite3.internal.sql.engine.util.IgniteSqlDateTimeUtils;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.sql.engine.util.format.SqlDateTimeFormatter;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.ColumnType;
import org.apache.ignite3.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class IgniteSqlFunctions {
    public static final long TIMESTAMP_MIN_INTERNAL = (Long)TypeUtils.toInternal(SchemaUtils.DATETIME_MIN, ColumnType.DATETIME);
    public static final long TIMESTAMP_MAX_INTERNAL = (Long)TypeUtils.toInternal(SchemaUtils.DATETIME_MAX, ColumnType.DATETIME);
    private static final long TIMESTAMP_LTZ_MIN_INTERNAL = (Long)TypeUtils.toInternal(SchemaUtils.TIMESTAMP_MIN, ColumnType.TIMESTAMP);
    private static final long TIMESTAMP_LTZ_MAX_INTERNAL = (Long)TypeUtils.toInternal(SchemaUtils.TIMESTAMP_MAX, ColumnType.TIMESTAMP);
    private static final int DATE_MIN_INTERNAL = (Integer)TypeUtils.toInternal(SchemaUtils.DATE_MIN, ColumnType.DATE);
    private static final int DATE_MAX_INTERNAL = (Integer)TypeUtils.toInternal(SchemaUtils.DATE_MAX, ColumnType.DATE);
    private static final LocalDate JAVA_SQL_TIME_DATE = LocalDate.of(1970, 1, 1);

    private IgniteSqlFunctions() {
    }

    @Nullable
    public static String toString(@Nullable BigDecimal x) {
        return x == null ? null : x.toPlainString();
    }

    public static String toString(ByteString b) {
        return b == null ? null : new String(b.getBytes(), Commons.typeFactory().getDefaultCharset());
    }

    public static int length(Object b) {
        return b instanceof ByteString ? SqlFunctions.octetLength((ByteString)((ByteString)b)) : SqlFunctions.charLength((String)((String)b));
    }

    public static int octetLength(ByteString s) {
        return s.length();
    }

    public static int octetLength(String s) {
        return s.getBytes().length;
    }

    public static byte sround(byte b0) {
        return IgniteSqlFunctions.sround(b0, 0);
    }

    public static byte sround(byte b0, int b1) {
        return (byte)IgniteSqlFunctions.sround((int)b0, b1);
    }

    public static byte sround(short b0) {
        return (byte)IgniteSqlFunctions.sround(b0, 0);
    }

    public static short sround(short b0, int b1) {
        return (short)IgniteSqlFunctions.sround((int)b0, b1);
    }

    public static int sround(int b0) {
        return IgniteSqlFunctions.sround(b0, 0);
    }

    public static int sround(int b0, int b1) {
        if (b1 == 0) {
            return b0;
        }
        if (b1 > 0) {
            return b0;
        }
        return (int)IgniteSqlFunctions.sround((long)b0, b1);
    }

    public static long sround(long b0) {
        return IgniteSqlFunctions.sround(b0, 0);
    }

    public static long sround(long b0, int b1) {
        if (b1 == 0) {
            return b0;
        }
        if (b1 > 0) {
            return b0;
        }
        long abs = (long)Math.pow(10.0, Math.abs(b1));
        return IgniteSqlFunctions.divide(b0, abs, RoundingMode.HALF_UP) * abs;
    }

    public static double sround(double b0) {
        return IgniteSqlFunctions.sround(BigDecimal.valueOf(b0)).doubleValue();
    }

    public static double sround(double b0, int b1) {
        return IgniteSqlFunctions.sround(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static float sround(float b0) {
        return IgniteSqlFunctions.sround(BigDecimal.valueOf(b0)).floatValue();
    }

    public static float sround(float b0, int b1) {
        return IgniteSqlFunctions.sround(BigDecimal.valueOf(b0), b1).floatValue();
    }

    public static BigDecimal sround(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.HALF_UP);
    }

    public static BigDecimal sround(BigDecimal b0, int b1) {
        int originalScale = b0.scale();
        if (b1 >= originalScale) {
            return b0;
        }
        BigDecimal roundedValue = b0.setScale(b1, RoundingMode.HALF_UP);
        return roundedValue.setScale(originalScale, RoundingMode.UNNECESSARY);
    }

    public static byte struncate(byte b0) {
        return IgniteSqlFunctions.struncate(b0, 0);
    }

    public static byte struncate(byte b0, int b1) {
        return (byte)IgniteSqlFunctions.struncate((int)b0, b1);
    }

    public static byte struncate(short b0) {
        return (byte)IgniteSqlFunctions.struncate(b0, 0);
    }

    public static short struncate(short b0, int b1) {
        return (short)IgniteSqlFunctions.struncate((int)b0, b1);
    }

    public static int struncate(int b0) {
        return IgniteSqlFunctions.sround(b0, 0);
    }

    public static int struncate(int b0, int b1) {
        if (b1 == 0) {
            return b0;
        }
        if (b1 > 0) {
            return b0;
        }
        return (int)IgniteSqlFunctions.struncate((long)b0, b1);
    }

    public static long struncate(long b0) {
        return IgniteSqlFunctions.sround(b0, 0);
    }

    public static long struncate(long b0, int b1) {
        if (b1 == 0) {
            return b0;
        }
        if (b1 > 0) {
            return b0;
        }
        long abs = (long)Math.pow(10.0, Math.abs(b1));
        return IgniteSqlFunctions.divide(b0, abs, RoundingMode.DOWN) * abs;
    }

    public static double struncate(double b0) {
        return IgniteSqlFunctions.struncate(BigDecimal.valueOf(b0)).doubleValue();
    }

    public static double struncate(double b0, int b1) {
        return IgniteSqlFunctions.struncate(BigDecimal.valueOf(b0), b1).doubleValue();
    }

    public static float struncate(float b0) {
        return IgniteSqlFunctions.struncate(BigDecimal.valueOf(b0)).floatValue();
    }

    public static float struncate(float b0, int b1) {
        return IgniteSqlFunctions.struncate(BigDecimal.valueOf(b0), b1).floatValue();
    }

    public static BigDecimal struncate(BigDecimal b0) {
        return b0.setScale(0, RoundingMode.DOWN);
    }

    public static BigDecimal struncate(BigDecimal b0, int b1) {
        int originalScale = b0.scale();
        if (b1 >= originalScale) {
            return b0;
        }
        BigDecimal roundedValue = b0.setScale(b1, RoundingMode.DOWN);
        return roundedValue.setScale(originalScale, RoundingMode.UNNECESSARY);
    }

    public static BigDecimal toBigDecimal(double val, int precision, int scale) {
        return IgniteSqlFunctions.toBigDecimal((Number)val, precision, scale);
    }

    public static BigDecimal toBigDecimal(float val, int precision, int scale) {
        return IgniteSqlFunctions.toBigDecimal(Float.valueOf(val), precision, scale);
    }

    public static BigDecimal toBigDecimal(long val, int precision, int scale) {
        BigDecimal decimal = BigDecimal.valueOf(val);
        return IgniteSqlFunctions.toBigDecimal(decimal, precision, scale);
    }

    public static BigDecimal toBigDecimal(int val, int precision, int scale) {
        BigDecimal decimal = new BigDecimal(val);
        return IgniteSqlFunctions.toBigDecimal(decimal, precision, scale);
    }

    public static BigDecimal toBigDecimal(short val, int precision, int scale) {
        BigDecimal decimal = new BigDecimal(val);
        return IgniteSqlFunctions.toBigDecimal(decimal, precision, scale);
    }

    public static BigDecimal toBigDecimal(byte val, int precision, int scale) {
        BigDecimal decimal = new BigDecimal(val);
        return IgniteSqlFunctions.toBigDecimal(decimal, precision, scale);
    }

    public static BigDecimal toBigDecimal(boolean val, int precision, int scale) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public static BigDecimal toBigDecimal(@Nullable String s, int precision, int scale) {
        if (s == null) {
            return null;
        }
        BigDecimal decimal = new BigDecimal(s.trim());
        return IgniteSqlFunctions.toBigDecimal(decimal, precision, scale);
    }

    @Nullable
    public static BigDecimal toBigDecimal(@Nullable Object o, int precision, int scale) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            throw new UnsupportedOperationException();
        }
        return o instanceof Number ? IgniteSqlFunctions.toBigDecimal((Number)o, precision, scale) : IgniteSqlFunctions.toBigDecimal(o.toString(), precision, scale);
    }

    @Nullable
    public static BigDecimal toBigDecimal(@Nullable Number value, int precision, int scale) {
        assert (precision > 0) : "Invalid precision: " + precision;
        if (value == null) {
            return null;
        }
        if (value.longValue() == 0L) {
            return IgniteSqlFunctions.processFractionData(value, precision, scale);
        }
        return IgniteSqlFunctions.processValueWithIntegralPart(value, precision, scale);
    }

    @Nullable
    public static Integer toTimeExact(@Nullable Object object, int precision) {
        if (object == null) {
            return null;
        }
        assert (object instanceof Integer) : object.getClass();
        return IgniteSqlDateTimeUtils.adjustTimeMillis((Integer)object, precision);
    }

    public static int toTimeExact(long val, int precision) {
        assert (precision >= 0) : "Invalid precision: " + precision;
        return IgniteSqlDateTimeUtils.adjustTimeMillis(Math.toIntExact(val), precision);
    }

    @Nullable
    public static Integer toDateExact(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        assert (object instanceof Integer) : object.getClass();
        return IgniteSqlFunctions.toDateExact((Integer)object);
    }

    public static Integer toDateExact(long longDate) {
        return IgniteSqlFunctions.toDateExact(Math.toIntExact(longDate));
    }

    public static Integer toDateExact(int intDate) {
        if (intDate < DATE_MIN_INTERNAL || intDate > DATE_MAX_INTERNAL) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, SqlTypeName.DATE + " out of range");
        }
        return intDate;
    }

    @Nullable
    public static Long toTimestampExact(@Nullable Object object, int precision) {
        if (object == null) {
            return null;
        }
        assert (object instanceof Long) : object.getClass();
        return IgniteSqlFunctions.toTimestampExact((Long)object, precision);
    }

    public static long toTimestampExact(long ts, int precision) {
        assert (precision >= 0) : "Invalid precision: " + precision;
        long verified = IgniteSqlFunctions.toTimestampExact(ts);
        return IgniteSqlDateTimeUtils.adjustTimestampMillis(verified, precision);
    }

    @Nullable
    public static Long toTimestampExact(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        assert (object instanceof Long) : object.getClass();
        return IgniteSqlFunctions.toTimestampExact((Long)object);
    }

    public static long toTimestampExact(long ts) {
        if (ts < TIMESTAMP_MIN_INTERNAL || ts > TIMESTAMP_MAX_INTERNAL) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, SqlTypeName.TIMESTAMP + " out of range");
        }
        return ts;
    }

    @Nullable
    public static Long toTimestampLtzExact(@Nullable Object object, int precision) {
        if (object == null) {
            return null;
        }
        assert (object instanceof Long) : object.getClass();
        return IgniteSqlFunctions.toTimestampLtzExact((Long)object, precision);
    }

    public static long toTimestampLtzExact(long ts, int precision) {
        assert (precision >= 0) : "Invalid precision: " + precision;
        long verified = IgniteSqlFunctions.toTimestampLtzExact(ts);
        return IgniteSqlDateTimeUtils.adjustTimestampMillis(verified, precision);
    }

    @Nullable
    public static Long toTimestampLtzExact(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        assert (object instanceof Long) : object.getClass();
        return IgniteSqlFunctions.toTimestampLtzExact((Long)object);
    }

    public static long toTimestampLtzExact(long ts) {
        if (ts < TIMESTAMP_LTZ_MIN_INTERNAL || ts > TIMESTAMP_LTZ_MAX_INTERNAL) {
            throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE + " out of range");
        }
        return ts;
    }

    public static double log(double d0, double d1) {
        return Math.log(d0) / Math.log(d1);
    }

    public static double log(double d0, BigDecimal d1) {
        return Math.log(d0) / Math.log(d1.doubleValue());
    }

    public static double log(BigDecimal d0, double d1) {
        return Math.log(d0.doubleValue()) / Math.log(d1);
    }

    public static double log(BigDecimal d0, BigDecimal d1) {
        return Math.log(d0.doubleValue()) / Math.log(d1.doubleValue());
    }

    public static double log10(double d0) {
        return Math.log10(d0);
    }

    public static double log10(BigDecimal d0) {
        return Math.log10(d0.doubleValue());
    }

    private static BigDecimal processValueWithIntegralPart(Number value, int precision, int scale) {
        int expectedSignificantDigits;
        BigDecimal dec = IgniteSqlFunctions.convertToBigDecimal(value);
        if (scale > precision) {
            throw IgniteSqlFunctions.numericOverflowError(precision, scale);
        }
        int currentSignificantDigits = dec.precision() - dec.scale();
        if (currentSignificantDigits > (expectedSignificantDigits = precision - scale)) {
            throw IgniteSqlFunctions.numericOverflowError(precision, scale);
        }
        return dec.setScale(scale, IgniteMath.ROUNDING_MODE);
    }

    private static BigDecimal processFractionData(Number value, int precision, int scale) {
        BigDecimal num = IgniteSqlFunctions.convertToBigDecimal(value);
        if (num.unscaledValue().equals(BigInteger.ZERO)) {
            return num.setScale(scale, RoundingMode.UNNECESSARY);
        }
        BigDecimal num0 = num.movePointRight(scale).setScale(0, RoundingMode.DOWN);
        int numPrecision = Math.min(num0.precision(), scale);
        if (numPrecision > precision) {
            throw IgniteSqlFunctions.numericOverflowError(precision, scale);
        }
        return num.setScale(scale, IgniteMath.ROUNDING_MODE);
    }

    private static BigDecimal convertToBigDecimal(Number value) {
        BigDecimal dec = value instanceof Float ? new BigDecimal(value.floatValue()) : (value instanceof Double ? new BigDecimal(value.doubleValue()) : (value instanceof BigDecimal ? (BigDecimal)value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : new BigDecimal(value.longValue()))));
        return dec;
    }

    private static SqlException numericOverflowError(int precision, int scale) {
        String maxVal = precision == scale ? "1" : IgniteStringFormatter.format("10^{}", precision - scale);
        String detail = IgniteStringFormatter.format("A field with precision {}, scale {} must round to an absolute value less than {}.", precision, scale, maxVal);
        throw new SqlException(ErrorGroups.Sql.RUNTIME_ERR, "Numeric field overflow. " + detail);
    }

    public static ByteString toByteString(String s) {
        return s == null ? null : new ByteString(s.getBytes(Commons.typeFactory().getDefaultCharset()));
    }

    @Nullable
    public static Object least2(Object arg0, Object arg1) {
        return IgniteSqlFunctions.leastOrGreatest(true, arg0, arg1);
    }

    @Nullable
    public static Object greatest2(Object arg0, Object arg1) {
        return IgniteSqlFunctions.leastOrGreatest(false, arg0, arg1);
    }

    @NonDeterministic
    public static UUID randUuid() {
        return UUID.randomUUID();
    }

    public static Object consumeFirstArgument(Object args0, Object args1) {
        return args1;
    }

    @Nullable
    public static Long toTimestampWithLocalTimeZone(@Nullable String v, String format, TimeZone timeZone) {
        if (v == null) {
            return null;
        }
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(timeZone, "timeZone");
        LocalDateTime dateTime = SqlDateTimeFormatter.timestampFormatter(format).parseTimestamp(v);
        Instant instant = dateTime.toInstant(ZoneOffset.UTC);
        ZoneRules rules = timeZone.toZoneId().getRules();
        ZoneOffset offset = rules.getOffset(instant);
        Instant adjusted = instant.minus(offset.getTotalSeconds(), ChronoUnit.SECONDS);
        return adjusted.toEpochMilli();
    }

    @Nullable
    public static Integer toDate(@Nullable String v, String format) {
        if (v == null) {
            return null;
        }
        LocalDate date = SqlDateTimeFormatter.dateFormatter(format).parseDate(v);
        return SqlFunctions.toInt((Date)Date.valueOf(date));
    }

    @Nullable
    public static Integer toTime(@Nullable String v, String format) {
        if (v == null) {
            return null;
        }
        LocalTime time = SqlDateTimeFormatter.timeFormatter(format).parseTime(v);
        Instant instant = time.atDate(JAVA_SQL_TIME_DATE).toInstant(ZoneOffset.UTC);
        return (int)instant.toEpochMilli();
    }

    @Nullable
    public static Long toTimestamp(@Nullable String v, String format) {
        if (v == null) {
            return null;
        }
        LocalDateTime ts = SqlDateTimeFormatter.timestampFormatter(format).parseTimestamp(v);
        Instant instant = ts.toInstant(ZoneOffset.UTC);
        return instant.toEpochMilli();
    }

    @Nullable
    public static String formatDate(String format, @Nullable Integer v) {
        if (v == null) {
            return null;
        }
        LocalDate date = LocalDate.ofEpochDay(v.longValue());
        return SqlDateTimeFormatter.dateFormatter(format).formatDate(date);
    }

    @Nullable
    public static String formatTime(String format, @Nullable Integer v) {
        if (v == null) {
            return null;
        }
        LocalTime time = LocalTime.ofInstant(Instant.ofEpochMilli(v.longValue()), ZoneOffset.UTC);
        return SqlDateTimeFormatter.timeFormatter(format).formatTime(time);
    }

    @Nullable
    public static String formatTimestamp(String format, @Nullable Long v) {
        if (v == null) {
            return null;
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(v), ZoneOffset.UTC);
        return SqlDateTimeFormatter.timestampFormatter(format).formatTimestamp(dateTime, ZoneOffset.UTC);
    }

    @Nullable
    public static String formatTimestampWithLocalTimeZone(String format, @Nullable Long v, TimeZone timeZone) {
        if (v == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(v);
        ZoneRules rules = timeZone.toZoneId().getRules();
        ZoneOffset offset = rules.getOffset(instant);
        LocalDateTime value = LocalDateTime.ofEpochSecond(instant.getEpochSecond(), instant.getNano(), offset);
        return SqlDateTimeFormatter.timestampFormatter(format).formatTimestamp(value, offset);
    }

    @Nullable
    private static Object leastOrGreatest(boolean least, Object arg0, Object arg1) {
        if (arg0 == null || arg1 == null) {
            return null;
        }
        assert (arg0 instanceof Comparable && arg1 instanceof Comparable) : "Unexpected class [arg0=" + arg0.getClass().getName() + ", arg1=" + arg1.getClass().getName() + "]";
        if (((Comparable)arg0).compareTo(arg1) < 0) {
            return least ? arg0 : arg1;
        }
        return least ? arg1 : arg0;
    }

    private static long divide(long p, long q, RoundingMode mode) {
        boolean increment;
        long div = p / q;
        long rem = p - q * div;
        int signum = 1 | (int)((p ^ q) >> 63);
        switch (mode) {
            case HALF_DOWN: 
            case HALF_UP: {
                long absRem = Math.abs(rem);
                long cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0L) {
                    increment = mode == RoundingMode.HALF_UP;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0L;
                break;
            }
            case DOWN: {
                increment = false;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + (long)signum : div;
    }

    @Nullable
    public static String nextGreaterPrefix(@Nullable String prefix) {
        if (prefix == null) {
            return null;
        }
        for (int i = prefix.length() - 1; i >= 0; --i) {
            char c = prefix.charAt(i);
            if (c >= '\uffff') continue;
            return prefix.substring(0, i) + (char)(c + '\u0001');
        }
        return null;
    }

    @Nullable
    public static String findPrefix(@Nullable String pattern, @Nullable String escape) {
        if (pattern == null) {
            return null;
        }
        if (escape != null && escape.length() != 1) {
            throw new IllegalArgumentException("Invalid escape character '" + escape + "'.");
        }
        if (escape == null) {
            int cutPoint = IgniteSqlFunctions.findCutPoint(pattern);
            if (cutPoint == 0) {
                return "";
            }
            return pattern.substring(0, cutPoint);
        }
        return IgniteSqlFunctions.findPrefix(pattern, escape.charAt(0));
    }

    private static String findPrefix(String pattern, char escape) {
        StringBuilder prefix = new StringBuilder(pattern.length());
        int lastAppendEnd = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            char current = pattern.charAt(i);
            if (current == escape) {
                char nextChar;
                int nextCharIdx = i + 1;
                if (nextCharIdx >= pattern.length() || (nextChar = pattern.charAt(nextCharIdx)) != escape && nextChar != '%' && nextChar != '_') continue;
                if (lastAppendEnd < i) {
                    prefix.append(pattern, lastAppendEnd, i);
                }
                prefix.append(nextChar);
                lastAppendEnd = ++i + 1;
                continue;
            }
            if (current != '%' && current != '_') continue;
            if (lastAppendEnd < i) {
                prefix.append(pattern, lastAppendEnd, i);
            }
            return prefix.toString();
        }
        if (lastAppendEnd < pattern.length()) {
            prefix.append(pattern, lastAppendEnd, pattern.length());
        }
        return prefix.toString();
    }

    private static int findCutPoint(String pattern) {
        for (int i = 0; i < pattern.length(); ++i) {
            char current = pattern.charAt(i);
            if (current != '%' && current != '_') continue;
            return i;
        }
        return pattern.length();
    }
}

