/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Static;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteMultiRowPkReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteMultiRowReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite3.internal.replicator.ReplicaService;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.replicator.message.ReplicaRequest;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.sql.engine.api.expressions.RowAccessor;
import org.apache.ignite3.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite3.internal.sql.engine.exec.TxAttributes;
import org.apache.ignite3.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite3.internal.sql.engine.exec.mapping.ColocationGroup;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteSqlValidatorErrorMessages;
import org.apache.ignite3.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.RowTypeUtils;
import org.apache.ignite3.internal.sql.engine.util.TypeUtils;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.distributed.storage.InternalTableImpl;
import org.apache.ignite3.internal.table.distributed.storage.RowBatch;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.type.StructNativeType;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public final class UpdatableTableImpl
implements UpdatableTable {
    private static final IgniteLogger LOG = Loggers.forClass(UpdatableTableImpl.class);
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final int tableId;
    private final int zoneId;
    private final TableDescriptor desc;
    private final ClockService clockService;
    private final InternalTable table;
    private final ReplicaService replicaService;
    private final PartitionExtractor partitionExtractor;
    private final TableRowConverter rowConverter;
    private StructNativeType rowSchema;

    UpdatableTableImpl(TableDescriptor desc, InternalTable table, ReplicaService replicaService, ClockService clockService, TableRowConverter rowConverter) {
        this.tableId = table.tableId();
        this.zoneId = table.zoneId();
        this.table = table;
        this.desc = desc;
        this.replicaService = replicaService;
        this.clockService = clockService;
        this.partitionExtractor = row -> IgniteUtils.safeAbs(row.colocationHash()) % table.partitions();
        this.rowConverter = rowConverter;
    }

    @Override
    public <RowT> CompletableFuture<?> upsertAll(ExecutionContext<RowT> ectx, List<RowT> rows, ColocationGroup colocationGroup) {
        TxAttributes txAttributes = ectx.txAttributes();
        ZonePartitionId commitPartitionId = txAttributes.commitPartition();
        assert (commitPartitionId != null);
        this.validateNotNullConstraint((RowHandler<RowT>)ectx.rowAccessor(), (RowT)rows);
        RelDataType rowType = RowTypeUtils.rowType(this.descriptor(), ectx.getTypeFactory());
        Supplier<StructNativeType> schemaSupplier = this.makeSchemaSupplier(ectx);
        rows = UpdatableTableImpl.validateCharactersOverflowAndTrimIfPossible(rowType, ectx, rows, schemaSupplier);
        Int2ObjectOpenHashMap rowsByPartition = new Int2ObjectOpenHashMap();
        for (RowT row : rows) {
            BinaryRowEx binaryRow = this.rowConverter.toFullRow(ectx, row);
            ((List)rowsByPartition.computeIfAbsent(this.partitionExtractor.fromRow(binaryRow), k -> new ArrayList())).add(binaryRow);
        }
        CompletableFuture[] futures = new CompletableFuture[rowsByPartition.size()];
        int batchNum = 0;
        for (Int2ObjectMap.Entry partToRows : rowsByPartition.int2ObjectEntrySet()) {
            ZonePartitionId partGroupId = new ZonePartitionId(this.zoneId, partToRows.getIntKey());
            NodeWithConsistencyToken nodeWithConsistencyToken = (NodeWithConsistencyToken)colocationGroup.assignments().get(partToRows.getIntKey());
            ReadWriteMultiRowReplicaRequest request = PARTITION_REPLICATION_MESSAGES_FACTORY.readWriteMultiRowReplicaRequest().groupId(ReplicaMessageUtils.toZonePartitionIdMessage(REPLICA_MESSAGES_FACTORY, partGroupId)).tableId(this.tableId).commitPartitionId(ReplicaMessageUtils.toZonePartitionIdMessage(REPLICA_MESSAGES_FACTORY, commitPartitionId)).schemaVersion(((BinaryRow)((List)partToRows.getValue()).get(0)).schemaVersion()).binaryTuples(UpdatableTableImpl.binaryRowsToBuffers((Collection)partToRows.getValue())).transactionId(txAttributes.id()).enlistmentConsistencyToken(nodeWithConsistencyToken.enlistmentConsistencyToken()).requestType(RequestType.RW_UPSERT_ALL).timestamp(this.clockService.now()).skipDelayedAck(true).coordinatorId(txAttributes.coordinatorId()).build();
            futures[batchNum++] = this.replicaService.invoke(nodeWithConsistencyToken.name(), (ReplicaRequest)request);
        }
        return CompletableFuture.allOf(futures);
    }

    private static List<ByteBuffer> binaryRowsToBuffers(Collection<BinaryRow> rows) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>(rows.size());
        for (BinaryRow row : rows) {
            result.add(row.tupleSlice());
        }
        return result;
    }

    private static List<ByteBuffer> serializePrimaryKeys(Collection<BinaryRow> rows) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>(rows.size());
        for (BinaryRow row : rows) {
            result.add(row.tupleSlice());
        }
        return result;
    }

    @Override
    public TableDescriptor descriptor() {
        return this.desc;
    }

    @Override
    public <RowT> CompletableFuture<Void> insert(InternalTransaction tx, ExecutionContext<RowT> ectx, RowT row) {
        assert (tx != null);
        this.validateNotNullConstraint((RowHandler<RowT>)ectx.rowAccessor(), row);
        RelDataType rowType = RowTypeUtils.rowType(this.descriptor(), ectx.getTypeFactory());
        Supplier<StructNativeType> schemaSupplier = this.makeSchemaSupplier(ectx);
        Object validatedRow = TypeUtils.validateStringTypesOverflowAndTrimIfPossible(rowType, ectx.rowAccessor(), ectx.rowFactoryFactory(), row, schemaSupplier);
        BinaryRowEx tableRow = this.rowConverter.toFullRow(ectx, validatedRow);
        return this.table.insert(tableRow, tx).thenApply(success -> {
            if (success.booleanValue()) {
                return null;
            }
            RowAccessor rowHandler = ectx.rowAccessor();
            throw UpdatableTableImpl.conflictKeysException(List.of(rowHandler.toString(validatedRow)));
        });
    }

    @Override
    public <RowT> CompletableFuture<?> insertAll(ExecutionContext<RowT> ectx, List<RowT> rows, ColocationGroup colocationGroup) {
        TxAttributes txAttributes = ectx.txAttributes();
        ZonePartitionId commitPartitionId = txAttributes.commitPartition();
        this.validateNotNullConstraint((RowHandler<RowT>)ectx.rowAccessor(), (RowT)rows);
        RelDataType rowType = RowTypeUtils.rowType(this.descriptor(), ectx.getTypeFactory());
        Supplier<StructNativeType> schemaSupplier = this.makeSchemaSupplier(ectx);
        rows = UpdatableTableImpl.validateCharactersOverflowAndTrimIfPossible(rowType, ectx, rows, schemaSupplier);
        assert (commitPartitionId != null);
        Int2ObjectMap<RowBatch> rowBatchByPartitionId = this.toRowBatchByPartitionId(ectx, rows);
        for (Int2ObjectMap.Entry partitionRowBatch : rowBatchByPartitionId.int2ObjectEntrySet()) {
            int partitionId = partitionRowBatch.getIntKey();
            RowBatch rowBatch = (RowBatch)partitionRowBatch.getValue();
            ZonePartitionId partGroupId = new ZonePartitionId(this.zoneId, partitionId);
            NodeWithConsistencyToken nodeWithConsistencyToken = (NodeWithConsistencyToken)colocationGroup.assignments().get(partitionId);
            ReadWriteMultiRowReplicaRequest request = PARTITION_REPLICATION_MESSAGES_FACTORY.readWriteMultiRowReplicaRequest().groupId(ReplicaMessageUtils.toZonePartitionIdMessage(REPLICA_MESSAGES_FACTORY, partGroupId)).tableId(this.tableId).commitPartitionId(ReplicaMessageUtils.toZonePartitionIdMessage(REPLICA_MESSAGES_FACTORY, commitPartitionId)).schemaVersion(rowBatch.requestedRows.get(0).schemaVersion()).binaryTuples(UpdatableTableImpl.binaryRowsToBuffers(rowBatch.requestedRows)).transactionId(txAttributes.id()).enlistmentConsistencyToken(nodeWithConsistencyToken.enlistmentConsistencyToken()).requestType(RequestType.RW_INSERT_ALL).timestamp(this.clockService.now()).skipDelayedAck(true).coordinatorId(txAttributes.coordinatorId()).build();
            rowBatch.resultFuture = this.replicaService.invoke(nodeWithConsistencyToken.name(), (ReplicaRequest)request);
        }
        return this.handleInsertResults(ectx, (Collection<RowBatch>)rowBatchByPartitionId.values());
    }

    private <RowT> Int2ObjectMap<RowBatch> toRowBatchByPartitionId(ExecutionContext<RowT> ectx, List<RowT> rows) {
        Int2ObjectOpenHashMap rowBatchByPartitionId = new Int2ObjectOpenHashMap();
        int i = 0;
        for (RowT row : rows) {
            BinaryRowEx binaryRow = this.rowConverter.toFullRow(ectx, row);
            ((RowBatch)rowBatchByPartitionId.computeIfAbsent(this.partitionExtractor.fromRow(binaryRow), partitionId -> new RowBatch())).add(binaryRow, i++);
        }
        return rowBatchByPartitionId;
    }

    @Override
    public <RowT> CompletableFuture<Boolean> delete(@Nullable InternalTransaction explicitTx, ExecutionContext<RowT> ectx, RowT key) {
        assert (explicitTx != null);
        BinaryRowEx keyRow = this.rowConverter.toKeyRow(ectx, key);
        return this.table.delete(keyRow, explicitTx);
    }

    @Override
    public <RowT> CompletableFuture<?> deleteAll(ExecutionContext<RowT> ectx, List<RowT> rows, ColocationGroup colocationGroup) {
        TxAttributes txAttributes = ectx.txAttributes();
        ZonePartitionId commitPartitionId = txAttributes.commitPartition();
        assert (commitPartitionId != null);
        Int2ObjectOpenHashMap keyRowsByPartition = new Int2ObjectOpenHashMap();
        for (RowT row : rows) {
            BinaryRowEx binaryRow = this.rowConverter.toKeyRow(ectx, row);
            ((List)keyRowsByPartition.computeIfAbsent(this.partitionExtractor.fromRow(binaryRow), k -> new ArrayList())).add(binaryRow);
        }
        CompletableFuture[] futures = new CompletableFuture[keyRowsByPartition.size()];
        int batchNum = 0;
        for (Int2ObjectMap.Entry partToRows : keyRowsByPartition.int2ObjectEntrySet()) {
            ZonePartitionId partGroupId = new ZonePartitionId(this.zoneId, partToRows.getIntKey());
            NodeWithConsistencyToken nodeWithConsistencyToken = (NodeWithConsistencyToken)colocationGroup.assignments().get(partToRows.getIntKey());
            ReadWriteMultiRowPkReplicaRequest request = PARTITION_REPLICATION_MESSAGES_FACTORY.readWriteMultiRowPkReplicaRequest().groupId(ReplicaMessageUtils.toZonePartitionIdMessage(REPLICA_MESSAGES_FACTORY, partGroupId)).tableId(this.tableId).commitPartitionId(ReplicaMessageUtils.toZonePartitionIdMessage(REPLICA_MESSAGES_FACTORY, commitPartitionId)).schemaVersion(((BinaryRow)((List)partToRows.getValue()).get(0)).schemaVersion()).primaryKeys(UpdatableTableImpl.serializePrimaryKeys((Collection)partToRows.getValue())).transactionId(txAttributes.id()).enlistmentConsistencyToken(nodeWithConsistencyToken.enlistmentConsistencyToken()).requestType(RequestType.RW_DELETE_ALL).timestamp(this.clockService.now()).skipDelayedAck(true).coordinatorId(txAttributes.coordinatorId()).build();
            futures[batchNum++] = this.replicaService.invoke(nodeWithConsistencyToken.name(), (ReplicaRequest)request);
        }
        return CompletableFuture.allOf(futures);
    }

    private <RowT> CompletableFuture<List<RowT>> handleInsertResults(ExecutionContext<RowT> ectx, Collection<RowBatch> batches) {
        return InternalTableImpl.collectRejectedRowsResponses(batches).thenApply(response -> {
            if (CollectionUtils.nullOrEmpty(response)) {
                return null;
            }
            RowAccessor handler = ectx.rowAccessor();
            IgniteTypeFactory typeFactory = ectx.getTypeFactory();
            RowFactory rowFactory = ectx.rowFactoryFactory().create(TypeUtils.convertStructuredType(RowTypeUtils.rowType(this.desc, typeFactory)));
            ArrayList<String> conflictRows = new ArrayList<String>(response.size());
            for (BinaryRow row : response) {
                conflictRows.add(handler.toString(this.rowConverter.toRow(ectx, row, rowFactory)));
            }
            throw UpdatableTableImpl.conflictKeysException(conflictRows);
        });
    }

    private static RuntimeException conflictKeysException(List<String> conflictKeys) {
        LOG.debug("Unable to insert rows because of conflict [rows={}]", conflictKeys);
        return new SqlException(ErrorGroups.Sql.CONSTRAINT_VIOLATION_ERR, "PK unique constraint is violated");
    }

    private static <RowT> List<RowT> validateCharactersOverflowAndTrimIfPossible(RelDataType rowType, ExecutionContext<RowT> context, List<RowT> rows, Supplier<StructNativeType> schemaSupplier) {
        ArrayList<RowT> out = new ArrayList<RowT>(rows.size());
        for (RowT row : rows) {
            out.add(TypeUtils.validateStringTypesOverflowAndTrimIfPossible(rowType, context.rowAccessor(), context.rowFactoryFactory(), row, schemaSupplier));
        }
        return out;
    }

    private <RowT> void validateNotNullConstraint(RowHandler<RowT> rowHandler, List<RowT> rows) {
        for (RowT row : rows) {
            this.validateNotNullConstraint(rowHandler, row);
        }
    }

    private <RowT> void validateNotNullConstraint(RowHandler<RowT> rowHandler, RowT row) {
        for (int i = 0; i < this.desc.columnsCount(); ++i) {
            ColumnDescriptor column = this.desc.columnDescriptor(i);
            if (column.nullable() || !rowHandler.isNull(i, row)) continue;
            Exception ex = Static.RESOURCE.columnNotNullable(column.name()).ex();
            String originalMessage = ex.getMessage();
            String resolvedMessage = IgniteSqlValidatorErrorMessages.resolveErrorMessage(originalMessage);
            throw new SqlException(ErrorGroups.Sql.CONSTRAINT_VIOLATION_ERR, resolvedMessage != null ? resolvedMessage : originalMessage);
        }
    }

    private <RowT> Supplier<StructNativeType> makeSchemaSupplier(ExecutionContext<RowT> ectx) {
        return () -> {
            if (this.rowSchema != null) {
                return this.rowSchema;
            }
            RelDataType rowType = RowTypeUtils.rowType(this.descriptor(), ectx.getTypeFactory());
            this.rowSchema = TypeUtils.convertStructuredType(rowType);
            return this.rowSchema;
        };
    }

    @FunctionalInterface
    private static interface PartitionExtractor {
        public int fromRow(BinaryRowEx var1);
    }
}

