/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.BinaryTuplePrefix;
import org.apache.ignite3.internal.sql.engine.api.expressions.RowAccessor;
import org.apache.ignite3.internal.sql.engine.api.expressions.RowFactory;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverterFactory;
import org.apache.ignite3.internal.sql.engine.exec.TxAttributes;
import org.apache.ignite3.internal.sql.engine.exec.exp.RangeCondition;
import org.apache.ignite3.internal.table.IndexScanCriteria;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.OperationContext;
import org.apache.ignite3.internal.table.TxContext;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.util.subscription.TransformingPublisher;
import org.jetbrains.annotations.Nullable;

public class ScannableTableImpl
implements ScannableTable {
    private final InternalTable internalTable;
    private final TableRowConverterFactory converterFactory;

    public ScannableTableImpl(InternalTable internalTable, TableRowConverterFactory converterFactory) {
        this.internalTable = internalTable;
        this.converterFactory = converterFactory;
    }

    @Override
    public <RowT> Flow.Publisher<RowT> scan(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithConsistencyToken, RowFactory<RowT> rowFactory, int @Nullable [] requiredColumns) {
        TxContext txContext = ScannableTableImpl.transactionalContextFrom(ctx.txAttributes(), partWithConsistencyToken.enlistmentConsistencyToken());
        int partId = partWithConsistencyToken.partId();
        Flow.Publisher<BinaryRow> pub = this.internalTable.scan(partId, ctx.localNode(), OperationContext.create(txContext));
        TableRowConverter rowConverter = this.converterFactory.create(requiredColumns, partId);
        return new TransformingPublisher<BinaryRow, Object>(pub, item -> rowConverter.toRow(ctx, (BinaryRow)item, rowFactory));
    }

    @Override
    public <RowT> Flow.Publisher<RowT> indexRangeScan(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithConsistencyToken, RowFactory<RowT> rowFactory, int indexId, List<String> columns, @Nullable RangeCondition<RowT> cond, int @Nullable [] requiredColumns) {
        BinaryTuplePrefix upper;
        BinaryTuplePrefix lower;
        TxContext txContext = ScannableTableImpl.transactionalContextFrom(ctx.txAttributes(), partWithConsistencyToken.enlistmentConsistencyToken());
        RowAccessor handler = ctx.rowAccessor();
        int flags = 0;
        if (cond == null) {
            flags = 3;
            lower = null;
            upper = null;
        } else {
            lower = ScannableTableImpl.toBinaryTuplePrefix(columns.size(), handler, cond.lower());
            upper = ScannableTableImpl.toBinaryTuplePrefix(columns.size(), handler, cond.upper());
            flags |= cond.lowerInclude() ? 1 : 0;
            flags |= cond.upperInclude() ? 2 : 0;
        }
        int partId = partWithConsistencyToken.partId();
        Flow.Publisher<BinaryRow> pub = this.internalTable.scan(partId, ctx.localNode(), indexId, IndexScanCriteria.range(lower, upper, flags), OperationContext.create(txContext));
        TableRowConverter rowConverter = this.converterFactory.create(requiredColumns, partId);
        return new TransformingPublisher<BinaryRow, Object>(pub, item -> rowConverter.toRow(ctx, (BinaryRow)item, rowFactory));
    }

    @Override
    public <RowT> Flow.Publisher<RowT> indexLookup(ExecutionContext<RowT> ctx, PartitionWithConsistencyToken partWithConsistencyToken, RowFactory<RowT> rowFactory, int indexId, List<String> columns, RowT key, int @Nullable [] requiredColumns) {
        TxContext txContext = ScannableTableImpl.transactionalContextFrom(ctx.txAttributes(), partWithConsistencyToken.enlistmentConsistencyToken());
        RowAccessor handler = ctx.rowAccessor();
        BinaryTuple keyTuple = handler.toBinaryTuple(key);
        assert (keyTuple.elementCount() == columns.size()) : IgniteStringFormatter.format("Key should contain exactly {} fields, but was {}", columns.size(), handler.toString(key));
        int partId = partWithConsistencyToken.partId();
        Flow.Publisher<BinaryRow> pub = this.internalTable.scan(partId, ctx.localNode(), indexId, IndexScanCriteria.lookup(keyTuple), OperationContext.create(txContext));
        TableRowConverter rowConverter = this.converterFactory.create(requiredColumns, partId);
        return new TransformingPublisher<BinaryRow, Object>(pub, item -> rowConverter.toRow(ctx, (BinaryRow)item, rowFactory));
    }

    @Override
    public <RowT> CompletableFuture<RowT> primaryKeyLookup(ExecutionContext<RowT> ctx, InternalTransaction tx, RowFactory<RowT> rowFactory, RowT key, int @Nullable [] requiredColumns) {
        assert (tx != null);
        TableRowConverter converter = this.converterFactory.create(requiredColumns);
        BinaryRowEx keyRow = converter.toKeyRow(ctx, key);
        return this.internalTable.get(keyRow, tx).thenApply(tableRow -> {
            if (tableRow == null) {
                return null;
            }
            return converter.toRow(ctx, (BinaryRow)tableRow, rowFactory);
        });
    }

    @Override
    public CompletableFuture<Long> estimatedSize() {
        return this.internalTable.estimatedSize();
    }

    @Nullable
    private static <RowT> BinaryTuplePrefix toBinaryTuplePrefix(int searchBoundSize, RowHandler<RowT> handler, @Nullable RowT prefix) {
        if (prefix == null) {
            return null;
        }
        int columnsCount = handler.columnsCount(prefix);
        if (columnsCount == 0) {
            return null;
        }
        if (searchBoundSize < columnsCount) {
            throw new IllegalStateException("Invalid range condition");
        }
        return BinaryTuplePrefix.fromBinaryTuple(searchBoundSize, handler.toBinaryTuple(prefix));
    }

    private static TxContext transactionalContextFrom(TxAttributes txAttributes, long enlistmentConsistencyToken) {
        if (txAttributes.readOnly()) {
            HybridTimestamp timestamp = txAttributes.time();
            assert (timestamp != null);
            return TxContext.readOnly(txAttributes.id(), txAttributes.coordinatorId(), timestamp);
        }
        ZonePartitionId commitPartition = txAttributes.commitPartition();
        assert (commitPartition != null);
        return TxContext.readWrite(txAttributes.id(), txAttributes.coordinatorId(), commitPartition, enlistmentConsistencyToken);
    }
}

