/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RuntimeIndex;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.FilteringIterator;
import org.jetbrains.annotations.Nullable;

public class RuntimeHashIndex<RowT>
implements RuntimeIndex<RowT> {
    private static final GroupKey NULL_KEY = new GroupKey(ArrayUtils.OBJECT_EMPTY_ARRAY);
    protected final ExecutionContext<RowT> ectx;
    private final ImmutableBitSet keys;
    private HashMap<GroupKey, List<RowT>> rows;
    private final boolean allowNulls;

    public RuntimeHashIndex(ExecutionContext<RowT> ectx, ImmutableBitSet keys, boolean allowNulls) {
        this.ectx = ectx;
        assert (!CollectionUtils.nullOrEmpty(keys));
        this.keys = keys;
        this.allowNulls = allowNulls;
        this.rows = new HashMap();
    }

    @Override
    public void push(RowT r) {
        GroupKey key = this.key(r);
        if (key == NULL_KEY) {
            return;
        }
        List eqRows = this.rows.computeIfAbsent(key, k -> new ArrayList());
        eqRows.add(r);
    }

    @Override
    public void close() {
        this.rows.clear();
    }

    public Iterable<RowT> scan(Supplier<RowT> searchRow, @Nullable Predicate<RowT> filter) {
        return new IndexScan(searchRow, filter);
    }

    private GroupKey key(RowT r) {
        GroupKey.Builder b = GroupKey.builder(this.keys.cardinality());
        for (Integer field : this.keys) {
            Object fieldVal = this.ectx.rowAccessor().get(field, r);
            if (fieldVal == null && !this.allowNulls) {
                return NULL_KEY;
            }
            b.add(fieldVal);
        }
        return b.build();
    }

    private class IndexScan
    implements Iterable<RowT>,
    AutoCloseable {
        private final Supplier<RowT> searchRow;
        private final Predicate<RowT> filter;

        IndexScan(@Nullable Supplier<RowT> searchRow, Predicate<RowT> filter) {
            this.searchRow = searchRow;
            this.filter = filter;
        }

        @Override
        public void close() {
        }

        @Override
        public Iterator<RowT> iterator() {
            GroupKey key = RuntimeHashIndex.this.key(this.searchRow.get());
            if (key == NULL_KEY) {
                return Collections.emptyIterator();
            }
            List eqRows = RuntimeHashIndex.this.rows.get(key);
            if (eqRows == null) {
                return Collections.emptyIterator();
            }
            return this.filter == null ? eqRows.iterator() : new FilteringIterator(eqRows.iterator(), this.filter);
        }
    }
}

