/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.SchemaSyncService;
import org.apache.ignite3.internal.sql.engine.exec.SqlPlanOutdatedException;
import org.apache.ignite3.internal.sql.engine.prepare.MultiStepPlan;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.jetbrains.annotations.TestOnly;

public class SqlPlanToTxSchemaVersionValidator {
    @TestOnly
    public static final SqlPlanToTxSchemaVersionValidator NOOP = new NoopSqlPlanToTxSchemaVersionValidator();
    private final SchemaSyncService schemaSyncService;
    private final CatalogService catalogService;

    public CompletableFuture<Void> validate(MultiStepPlan plan, QueryTransactionWrapper tx) {
        if (!tx.implicit()) {
            return CompletableFutures.nullCompletedFuture();
        }
        HybridTimestamp ts = tx.unwrap().schemaTimestamp();
        return this.schemaSyncService.waitForMetadataCompleteness(ts).thenRun(() -> {
            int requiredCatalog = this.catalogService.activeCatalogVersion(ts.longValue());
            if (requiredCatalog != plan.catalogVersion()) {
                throw new SqlPlanOutdatedException();
            }
        });
    }

    private SqlPlanToTxSchemaVersionValidator(SchemaSyncService schemaSyncService, CatalogService catalogService) {
        this.schemaSyncService = schemaSyncService;
        this.catalogService = catalogService;
    }

    public static SqlPlanToTxSchemaVersionValidator create(SchemaSyncService schemaSyncService, CatalogService catalogService) {
        return new SqlPlanToTxSchemaVersionValidator(schemaSyncService, catalogService);
    }

    private static class NoopSqlPlanToTxSchemaVersionValidator
    extends SqlPlanToTxSchemaVersionValidator {
        private NoopSqlPlanToTxSchemaVersionValidator() {
            super(null, null);
        }

        @Override
        public CompletableFuture<Void> validate(MultiStepPlan plan, QueryTransactionWrapper tx) {
            return CompletableFutures.nullCompletedFuture();
        }
    }
}

