/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.security.authentication;

import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.ignite3.configuration.ConfigurationModule;
import org.apache.ignite3.configuration.SuperRootChange;
import org.apache.ignite3.configuration.annotation.ConfigurationType;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.security.authentication.basic.BasicAuthenticationProviderChange;
import org.apache.ignite3.internal.security.authentication.basic.BasicAuthenticationProviderConfigurationSchema;
import org.apache.ignite3.internal.security.authentication.basic.UserPasswordEncodingValidatorImpl;
import org.apache.ignite3.internal.security.authentication.basic.UserWithSystemRoleValidatorImpl;
import org.apache.ignite3.internal.security.authentication.configuration.validator.AuthenticationRolesValidatorImpl;
import org.apache.ignite3.internal.security.authentication.validator.AuthenticationProvidersValidatorImpl;
import org.apache.ignite3.internal.security.configuration.SecurityChange;
import org.apache.ignite3.internal.security.configuration.SecurityExtensionConfiguration;
import org.apache.ignite3.internal.security.configuration.SecurityExtensionConfigurationSchema;
import org.gridgain.internal.rbac.configuration.PrivilegeNameGenerator;
import org.gridgain.internal.rbac.configuration.PrivilegesValidatorImpl;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.security.ldap.configuration.LdapAuthenticationProviderConfigurationSchema;
import org.gridgain.internal.security.ldap.configuration.validator.LdapUrlValidatorImpl;

@AutoService(value={ConfigurationModule.class})
public class SecurityConfigurationModule
implements ConfigurationModule {
    static final String DEFAULT_PROVIDER_NAME = "default";
    static final String DEFAULT_USERNAME = "ignite";
    static final String DEFAULT_PASSWORD = "ignite";

    @Override
    public ConfigurationType type() {
        return ConfigurationType.DISTRIBUTED;
    }

    @Override
    public Set<Validator<?, ?>> validators() {
        return Set.of(AuthenticationProvidersValidatorImpl.INSTANCE, LdapUrlValidatorImpl.INSTANCE, PrivilegesValidatorImpl.INSTANCE, AuthenticationRolesValidatorImpl.INSTANCE, UserWithSystemRoleValidatorImpl.INSTANCE, UserPasswordEncodingValidatorImpl.INSTANCE);
    }

    @Override
    public Collection<Class<?>> schemaExtensions() {
        return List.of(SecurityExtensionConfigurationSchema.class);
    }

    @Override
    public Collection<Class<?>> polymorphicSchemaExtensions() {
        return List.of(BasicAuthenticationProviderConfigurationSchema.class, LdapAuthenticationProviderConfigurationSchema.class);
    }

    @Override
    public void patchConfigurationWithDynamicDefaults(SuperRootChange rootChange) {
        SecurityChange securityExtensionChange = rootChange.changeRoot(SecurityExtensionConfiguration.KEY).changeSecurity();
        securityExtensionChange.changeAuthorization().changeRoles(roles -> roles.createOrUpdate("system", roleChange -> roleChange.changeDisplayName("system").changePrivileges(privileges -> {
            for (Action action : Action.values()) {
                privileges.createOrUpdate(PrivilegeNameGenerator.privilegeName(action.name(), null), privilege -> privilege.changeAction(action.name()));
            }
        })));
        securityExtensionChange.changeAuthentication().changeProviders(providersChange -> {
            if (providersChange.isEmpty()) {
                providersChange.create(DEFAULT_PROVIDER_NAME, change -> change.convert(BasicAuthenticationProviderChange.class).changeUsers().create("ignite", user -> user.changeDisplayName("ignite").changePassword("ignite").changeRoles("system")));
            }
        });
    }
}

