/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.secondarystoragebridge.rocksdb;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.components.LogSyncer;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.apache.ignite3.internal.rocksdb.flush.RocksDbFlusher;
import org.apache.ignite3.internal.secondarystoragebridge.SecondaryStorageBridge;
import org.apache.ignite3.internal.secondarystoragebridge.SecondaryStorageBridgeException;
import org.apache.ignite3.internal.secondarystoragebridge.UpdatesStorage;
import org.apache.ignite3.internal.secondarystoragebridge.rocksdb.RocksDbUpdatesStorage;
import org.apache.ignite3.internal.secondarystoragebridge.rocksdb.UpdatesStorageColumnFamily;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.gridgain.lang.GridgainErrorGroups;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.DBOptionsInterface;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class RocksDbSecondaryStorageBridge
implements SecondaryStorageBridge {
    private static final int FLUSH_DELAY = 100;
    private final ConcurrentMap<TablePartitionId, RocksDbUpdatesStorage> updatesStorages = new ConcurrentHashMap<TablePartitionId, RocksDbUpdatesStorage>();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final Path storagePath;
    private final List<AutoCloseable> resources = new CopyOnWriteArrayList<AutoCloseable>();
    private final ExecutorService rocksDbFlusherThreadPool;
    private final ScheduledExecutorService rocksDbFlusherScheduledPool;
    private final String nodeName;
    private final FailureProcessor failureProcessor;
    private final LogSyncer logSyncer;
    private volatile RocksDbFlusher flusher;
    private volatile ColumnFamily dataCf;
    private volatile ColumnFamily committedCf;
    private volatile ColumnFamily ongoingCf;
    private volatile ColumnFamily metaCf;

    public RocksDbSecondaryStorageBridge(String nodeName, Path storagePath, LogSyncer logSyncer, FailureProcessor failureProcessor, ExecutorService rocksDbFlusherThreadPool, ScheduledExecutorService rocksDbFlusherScheduledPool) {
        this.nodeName = nodeName;
        this.storagePath = storagePath;
        this.logSyncer = logSyncer;
        this.failureProcessor = failureProcessor;
        this.rocksDbFlusherThreadPool = rocksDbFlusherThreadPool;
        this.rocksDbFlusherScheduledPool = rocksDbFlusherScheduledPool;
    }

    ColumnFamily metaColumnFamily() {
        return this.metaCf;
    }

    ColumnFamily dataColumnFamily() {
        return this.dataCf;
    }

    ColumnFamily committedTransactionsColumnFamily() {
        return this.committedCf;
    }

    ColumnFamily ongoingTransactionsColumnFamily() {
        return this.ongoingCf;
    }

    @Override
    public void start() throws SecondaryStorageBridgeException {
        try {
            Files.createDirectories(this.storagePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_BRIDGE_STARTUP_ERR, "Failed to create directory: " + this.storagePath, (Throwable)e);
        }
        RocksDbFlusher flusher = new RocksDbFlusher("secondary storage bridge", this.nodeName, this.busyLock, this.rocksDbFlusherScheduledPool, this.rocksDbFlusherThreadPool, () -> 100, this.logSyncer, this.failureProcessor, this::onFlushCompleted);
        this.resources.add(flusher::stop);
        List<ColumnFamilyDescriptor> cfDescriptors = RocksDbSecondaryStorageBridge.getExistingCfDescriptors();
        cfDescriptors.stream().map(ColumnFamilyDescriptor::getOptions).forEach(this.resources::add);
        ArrayList<ColumnFamilyHandle> cfHandles = new ArrayList<ColumnFamilyHandle>(cfDescriptors.size());
        DBOptionsInterface dbOptions = new DBOptions().setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setAtomicFlush(true).setListeners((List)List.of(flusher.listener()));
        this.resources.add((AutoCloseable)((Object)dbOptions));
        ColumnFamily dataCf = null;
        ColumnFamily committedCf = null;
        ColumnFamily ongoingCf = null;
        ColumnFamily metaCf = null;
        try {
            RocksDB db = RocksDB.open((DBOptions)dbOptions, this.storagePath.toAbsolutePath().toString(), cfDescriptors, cfHandles);
            this.resources.add(db);
            block12: for (ColumnFamilyHandle cfHandle : cfHandles) {
                ColumnFamily cf = ColumnFamily.wrap(db, cfHandle);
                switch (UpdatesStorageColumnFamily.ColumnFamilyType.fromCfName(cf.name())) {
                    case META: {
                        metaCf = cf;
                        continue block12;
                    }
                    case DATA: {
                        dataCf = cf;
                        continue block12;
                    }
                    case COMMITTED: {
                        committedCf = cf;
                        continue block12;
                    }
                    case ONGOING: {
                        ongoingCf = cf;
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Unidentified column family [name=" + cf.name() + "]");
            }
            flusher.init(db, cfHandles);
        }
        catch (RocksDBException ex) {
            try {
                this.close();
            }
            catch (Exception closeException) {
                ex.addSuppressed(closeException);
            }
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_BRIDGE_STARTUP_ERR, "Failed to start rocksdb", (Throwable)ex);
        }
        assert (metaCf != null);
        assert (dataCf != null);
        assert (committedCf != null);
        assert (ongoingCf != null);
        this.dataCf = dataCf;
        this.committedCf = committedCf;
        this.ongoingCf = ongoingCf;
        this.metaCf = metaCf;
        this.flusher = flusher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatesStorage getOrCreateUpdatesStorage(int tableId, int partitionId) {
        if (!this.busyLock.enterBusy()) {
            throw new SecondaryStorageBridgeException(GridgainErrorGroups.SecondaryStorage.SECONDARY_STORAGE_BRIDGE_STARTUP_ERR, "Failed to access updates storage, component is stopped", null);
        }
        try {
            TablePartitionId key = new TablePartitionId(tableId, partitionId);
            UpdatesStorage updatesStorage = this.updatesStorages.computeIfAbsent(key, unused -> new RocksDbUpdatesStorage(this, tableId, partitionId));
            return updatesStorage;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<Void> flush() {
        return this.flusher.awaitFlush(true);
    }

    private static List<String> getExistingCfNames() {
        return List.of(UpdatesStorageColumnFamily.META_CF_NAME, "cf-data", "cf-committed", "cf-ongoing");
    }

    private static List<ColumnFamilyDescriptor> getExistingCfDescriptors() {
        return RocksDbSecondaryStorageBridge.getExistingCfNames().stream().map(RocksDbSecondaryStorageBridge::cfDescriptorFromName).collect(Collectors.toList());
    }

    private static ColumnFamilyDescriptor cfDescriptorFromName(String cfName) {
        int prefixSize;
        switch (UpdatesStorageColumnFamily.ColumnFamilyType.fromCfName(cfName)) {
            case META: {
                prefixSize = 6;
                break;
            }
            case DATA: {
                prefixSize = 22;
                break;
            }
            case COMMITTED: {
                prefixSize = 6;
                break;
            }
            case ONGOING: {
                prefixSize = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unidentified column family [name=" + cfName + "]");
            }
        }
        return new ColumnFamilyDescriptor(cfName.getBytes(StandardCharsets.UTF_8), new ColumnFamilyOptions().useFixedLengthPrefixExtractor(prefixSize));
    }

    private void onFlushCompleted() {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.updatesStorages.values().forEach(RocksDbUpdatesStorage::refreshPersistedIndex);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void close() throws Exception {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        Collections.reverse(this.resources);
        IgniteUtils.closeAll(Stream.concat(this.updatesStorages.values().stream(), this.resources.stream()));
    }
}

