/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.secondarystoragebridge;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.secondarystoragebridge.TransactionInfo;
import org.apache.ignite3.internal.secondarystoragebridge.UpdatesStorage;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.secondary.BinaryRowAndRowId;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.worker.ThreadAssertingCursor;
import org.apache.ignite3.internal.worker.ThreadAssertions;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingUpdatesStorage
implements UpdatesStorage {
    private final UpdatesStorage storage;

    ThreadAssertingUpdatesStorage(UpdatesStorage storage) {
        this.storage = storage;
    }

    @Override
    public void onNewWrite(UUID txId, RowId rowId, BinaryRow row) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.onNewWrite(txId, rowId, row);
    }

    @Override
    public void onTransactionAborted(UUID txId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.onTransactionAborted(txId);
    }

    @Override
    public void onTransactionCommitted(UUID txId, HybridTimestamp commitTimestamp) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.onTransactionCommitted(txId, commitTimestamp);
    }

    @Override
    public void dropTransactionData(HybridTimestamp upperBoundTimestamp, RowId upperBoundRowId) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.dropTransactionData(upperBoundTimestamp, upperBoundRowId);
    }

    @Override
    public void dropTransactionData(Collection<TransactionInfo> ids) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.dropTransactionData(ids);
    }

    @Override
    public long lastAppliedIndex() {
        return this.storage.lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.storage.lastAppliedTerm();
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.lastApplied(lastAppliedIndex, lastAppliedTerm);
    }

    @Override
    public void updateConfiguration(long lastAppliedIndex, long lastAppliedTerm, byte[] configuration) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.updateConfiguration(lastAppliedIndex, lastAppliedTerm, configuration);
    }

    @Override
    public long persistedIndex() {
        return this.storage.persistedIndex();
    }

    @Override
    public byte @Nullable [] configuration() {
        return this.storage.configuration();
    }

    @Override
    public Cursor<TransactionInfo> getCommittedTransactionIds(HybridTimestamp lowerBound, HybridTimestamp upperBound) {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor<TransactionInfo>(this.storage.getCommittedTransactionIds(lowerBound, upperBound));
    }

    @Override
    public Cursor<BinaryRowAndRowId> getTransactionData(UUID txId, @Nullable RowId rowId) {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor<BinaryRowAndRowId>(this.storage.getTransactionData(txId, rowId));
    }

    @Override
    public CompletableFuture<Void> flush() {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.storage.flush();
    }

    @Override
    public void updateLease(long leaseStartTime, UUID primaryReplicaNodeId, String primaryReplicaNodeName) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.storage.updateLease(leaseStartTime, primaryReplicaNodeId, primaryReplicaNodeName);
    }

    @Override
    public long leaseStartTime() {
        return this.storage.leaseStartTime();
    }

    @Override
    @Nullable
    public UUID primaryReplicaNodeId() {
        return this.storage.primaryReplicaNodeId();
    }

    @Override
    @Nullable
    public String primaryReplicaNodeName() {
        return this.storage.primaryReplicaNodeName();
    }

    @Override
    public boolean hasOngoingTransactions(HybridTimestamp upperBound) {
        return this.storage.hasOngoingTransactions(upperBound);
    }

    @Override
    public boolean isCommitedStorageEmpty(HybridTimestamp lowerBound) {
        return this.storage.isCommitedStorageEmpty(lowerBound);
    }

    @Override
    public boolean isCommitedStorageLimitReached(HybridTimestamp lowerBound) {
        return this.storage.isCommitedStorageLimitReached(lowerBound);
    }
}

