/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.cluster;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cluster.management.ClusterInitializer;
import org.apache.ignite3.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite3.internal.network.ClusterService;
import org.apache.ignite3.internal.network.TopologyService;
import org.apache.ignite3.internal.rest.RestFactory;
import org.apache.ignite3.internal.rest.cluster.JoinFutureProvider;

@Factory
public class ClusterManagementRestFactory
implements RestFactory {
    private ClusterService clusterService;
    private ClusterInitializer clusterInitializer;
    private ClusterManagementGroupManager cmgManager;
    private JoinFutureProvider joinFutureProvider;

    public ClusterManagementRestFactory(ClusterService clusterService, ClusterInitializer clusterInitializer, ClusterManagementGroupManager cmgManager, JoinFutureProvider joinFutureProvider) {
        this.clusterService = clusterService;
        this.clusterInitializer = clusterInitializer;
        this.cmgManager = cmgManager;
        this.joinFutureProvider = joinFutureProvider;
    }

    @Bean
    @Singleton
    public ClusterInitializer clusterInitializer() {
        return this.clusterInitializer;
    }

    @Bean
    @Singleton
    public ClusterManagementGroupManager cmgManager() {
        return this.cmgManager;
    }

    @Bean
    @Singleton
    public TopologyService topologyService() {
        return this.clusterService.topologyService();
    }

    @Bean
    @Singleton
    public JoinFutureProvider joinFutureProvider() {
        return this.joinFutureProvider;
    }

    @Override
    public void cleanResources() {
        this.clusterService = null;
        this.clusterInitializer = null;
        this.cmgManager = null;
        this.joinFutureProvider = null;
    }
}

