/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.snapshot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.rest.api.snapshot.PathType;
import org.apache.ignite3.internal.rest.api.snapshot.SnapshotType;
import org.jetbrains.annotations.Nullable;

@Schema(description="Snapshot list command item.")
public class SnapshotListItem {
    @Schema(description="Snapshot ID.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final UUID id;
    @Schema(description="Parent snapshot ID.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final UUID parentId;
    @Schema(description="Snapshot type.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final SnapshotType type;
    @Schema(description="Point in time at which the snapshot was created in milliseconds.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final long creationTime;
    @Schema(description="Snapshot path name specified in the configuration.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final String uriName;
    @Schema(description="Snapshot path type specified in the configuration.", requiredMode=Schema.RequiredMode.REQUIRED)
    private final PathType uriType;
    @Schema(description="Snapshot path URI specified in the configuration.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final String uri;
    @Schema(description="Number of nodes for which a snapshot was created.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final Integer targetNodeSize;
    @Schema(description="Number of nodes on which the snapshot is present.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final Integer actualNodeSize;
    @Schema(description="Names of the nodes for which the snapshot was created.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final Set<String> targetNodeNames;
    @Schema(description="Names of the nodes on which the snapshot is present.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final Set<String> actualNodeNames;
    @Schema(description="Number of tables that are present in the snapshot.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final Integer tableNumber;
    @Schema(description="Names of the tables that are present in the snapshot.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final Set<String> tableNames;

    @JsonCreator
    public SnapshotListItem(@JsonProperty(value="id") UUID id, @JsonProperty(value="parentId") @Nullable UUID parentId, @JsonProperty(value="type") SnapshotType type, @JsonProperty(value="creationTime") long creationTime, @JsonProperty(value="uriName") String uriName, @JsonProperty(value="uriType") String uriType, @JsonProperty(value="uri") @Nullable String uri, @JsonProperty(value="targetNodeSize") @Nullable Integer targetNodeSize, @JsonProperty(value="actualNodeSize") @Nullable Integer actualNodeSize, @JsonProperty(value="targetNodeNames") @Nullable Set<String> targetNodeNames, @JsonProperty(value="actualNodeNames") @Nullable Set<String> actualNodeNames, @JsonProperty(value="tableNumber") @Nullable Integer tableNumber, @JsonProperty(value="tableNames") @Nullable Set<String> tableNames) {
        this.id = id;
        this.parentId = parentId;
        this.type = type;
        this.creationTime = creationTime;
        this.uriName = uriName;
        this.uriType = PathType.valueOf(uriType);
        this.uri = uri;
        this.targetNodeSize = targetNodeSize;
        this.actualNodeSize = actualNodeSize;
        this.targetNodeNames = targetNodeNames;
        this.actualNodeNames = actualNodeNames;
        this.tableNumber = tableNumber;
        this.tableNames = tableNames;
    }

    @JsonGetter(value="id")
    public UUID id() {
        return this.id;
    }

    @JsonGetter(value="parentId")
    @Nullable
    public UUID parentId() {
        return this.parentId;
    }

    @JsonGetter(value="type")
    public SnapshotType type() {
        return this.type;
    }

    @JsonGetter(value="creationTime")
    public long creationTime() {
        return this.creationTime;
    }

    @JsonGetter(value="uriName")
    public String uriName() {
        return this.uriName;
    }

    @JsonGetter(value="uriType")
    public PathType uriType() {
        return this.uriType;
    }

    @JsonGetter(value="uri")
    @Nullable
    public String uri() {
        return this.uri;
    }

    @JsonGetter(value="targetNodeSize")
    @Nullable
    public Integer targetNodeSize() {
        return this.targetNodeSize;
    }

    @JsonGetter(value="actualNodeSize")
    @Nullable
    public Integer actualNodeSize() {
        return this.actualNodeSize;
    }

    @JsonGetter(value="targetNodeNames")
    @Nullable
    public Set<String> targetNodeNames() {
        return this.targetNodeNames;
    }

    @JsonGetter(value="actualNodeNames")
    @Nullable
    public Set<String> actualNodeNames() {
        return this.actualNodeNames;
    }

    @JsonGetter(value="tableNumber")
    @Nullable
    public Integer tableNumber() {
        return this.tableNumber;
    }

    @JsonGetter(value="tableNames")
    @Nullable
    public Set<String> tableNames() {
        return this.tableNames;
    }
}

