/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.deployment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="Unit content entry.")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=UnitFile.class, name="file"), @JsonSubTypes.Type(value=UnitFolder.class, name="folder")})
public interface UnitEntry {
    @JsonGetter(value="name")
    public String name();

    @JsonGetter(value="size")
    public long size();

    @Schema(description="Unit content folder.")
    public static class UnitFolder
    implements UnitEntry {
        @Schema(description="Unit content folder name.", requiredMode=Schema.RequiredMode.REQUIRED)
        private final String name;
        @Schema(description="Unit content folder elements.", requiredMode=Schema.RequiredMode.REQUIRED)
        private final List<UnitEntry> children;

        @JsonCreator
        public UnitFolder(@JsonProperty(value="name") String name, @JsonProperty(value="children") List<UnitEntry> children) {
            this.name = name;
            this.children = children;
        }

        @Override
        @JsonGetter(value="name")
        public String name() {
            return this.name;
        }

        @Override
        public long size() {
            return this.children.stream().mapToLong(UnitEntry::size).sum();
        }

        @JsonGetter(value="children")
        public List<UnitEntry> children() {
            return this.children;
        }
    }

    @Schema(description="Unit content file.")
    public static class UnitFile
    implements UnitEntry {
        @Schema(description="Unit content file name.", requiredMode=Schema.RequiredMode.REQUIRED)
        private final String name;
        @Schema(description="Unit content file size in bytes.", requiredMode=Schema.RequiredMode.REQUIRED)
        private final long size;

        @JsonCreator
        public UnitFile(@JsonProperty(value="name") String name, @JsonProperty(value="size") long size) {
            this.name = name;
            this.size = size;
        }

        @Override
        @JsonGetter(value="name")
        public String name() {
            return this.name;
        }

        @Override
        @JsonGetter(value="size")
        public long size() {
            return this.size;
        }
    }
}

