/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.dcr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class SslConfig {
    @Schema(description="ciphers", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final Set<String> ciphers;
    @Schema(description="Key store path that will be used to setup SSL connection.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final String keyStorePath;
    @Schema(description="Key store password.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final String keyStorePassword;
    @Schema(description="Trust store path that will be used to setup SSL connection..", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final String trustStorePath;
    @Schema(description="Trust store password.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @Nullable
    private final String trustStorePassword;

    @JsonCreator
    public SslConfig(@JsonProperty(value="ciphers") @Nullable Set<String> ciphers, @JsonProperty(value="keyStorePath") @Nullable String keyStorePath, @JsonProperty(value="keyStorePassword") @Nullable String keyStorePassword, @JsonProperty(value="trustStorePath") @Nullable String trustStorePath, @JsonProperty(value="trustStorePassword") @Nullable String trustStorePassword) {
        this.ciphers = ciphers;
        this.keyStorePath = keyStorePath;
        this.keyStorePassword = keyStorePassword;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
    }

    @JsonGetter
    public Set<String> ciphers() {
        return this.ciphers;
    }

    @JsonGetter
    public String keyStorePath() {
        return this.keyStorePath;
    }

    @JsonGetter
    public String keyStorePassword() {
        return this.keyStorePassword;
    }

    @JsonGetter
    public String trustStorePath() {
        return this.trustStorePath;
    }

    @JsonGetter
    public String trustStorePassword() {
        return this.trustStorePassword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslConfig sslConfig = (SslConfig)o;
        return Objects.equals(this.ciphers, sslConfig.ciphers) && Objects.equals(this.keyStorePath, sslConfig.keyStorePath) && Objects.equals(this.keyStorePassword, sslConfig.keyStorePassword) && Objects.equals(this.trustStorePath, sslConfig.trustStorePath) && Objects.equals(this.trustStorePassword, sslConfig.trustStorePassword);
    }

    public int hashCode() {
        return Objects.hash(this.ciphers, this.keyStorePath, this.keyStorePassword, this.trustStorePath, this.trustStorePassword);
    }
}

