/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.ignite3.internal.network.UnresolvableConsistentIdException;
import org.apache.ignite3.internal.raft.GroupOverloadedException;
import org.apache.ignite3.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite3.internal.replicator.exception.ReplicationException;
import org.apache.ignite3.internal.replicator.exception.ReplicationTimeoutException;
import org.apache.ignite3.internal.util.ExceptionUtils;

public class ReplicatorRecoverableExceptions {
    private static final Set<Class<? extends Throwable>> RECOVERABLE = Set.of(TimeoutException.class, IOException.class, UnresolvableConsistentIdException.class, ReplicationException.class, ReplicationTimeoutException.class, PrimaryReplicaMissException.class, GroupOverloadedException.class);

    public static boolean isRecoverable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        Throwable candidate = ExceptionUtils.unwrapRootCause(throwable);
        for (Class<? extends Throwable> recoverableClass : RECOVERABLE) {
            if (!recoverableClass.isAssignableFrom(candidate.getClass())) continue;
            return true;
        }
        return false;
    }
}

