/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.Arrays;

class SegmentInfo {
    static int MISSING_SEGMENT_FILE_OFFSET = 0;
    private static final VarHandle SEGMENT_FILE_OFFSETS_VH;
    private final long logIndexBase;
    private final long firstIndexKept;
    private volatile ArrayWithSize segmentFileOffsets;

    SegmentInfo(long logIndexBase) {
        this(logIndexBase, -1L, new ArrayWithSize());
    }

    SegmentInfo(long logIndexBase, long firstIndexKept) {
        this(logIndexBase, firstIndexKept, new ArrayWithSize());
    }

    static SegmentInfo prefixTombstone(long firstIndexKept) {
        return new SegmentInfo(-1L, firstIndexKept);
    }

    static SegmentInfo resetTombstone(long nextLogIndex) {
        return new SegmentInfo(nextLogIndex + 1L, nextLogIndex);
    }

    private SegmentInfo(long logIndexBase, long firstIndexKept, ArrayWithSize segmentFileOffsets) {
        this.logIndexBase = logIndexBase;
        this.firstIndexKept = firstIndexKept;
        this.segmentFileOffsets = segmentFileOffsets;
    }

    void addOffset(long logIndex, int segmentFileOffset) {
        assert (segmentFileOffset != MISSING_SEGMENT_FILE_OFFSET) : "Segment file offset cannot be 0";
        ArrayWithSize segmentFileOffsets = this.segmentFileOffsets;
        assert ((long)segmentFileOffsets.size() == logIndex - this.logIndexBase) : String.format("Log indexes are not monotonically increasing [logIndex=%d, expectedLogIndex=%d].", logIndex, this.logIndexBase + (long)segmentFileOffsets.size());
        this.setSegmentFileOffsets(segmentFileOffsets, segmentFileOffsets.add(segmentFileOffset));
    }

    int getOffset(long logIndex) {
        long offsetIndex = logIndex - this.logIndexBase;
        if (offsetIndex < 0L) {
            return MISSING_SEGMENT_FILE_OFFSET;
        }
        ArrayWithSize segmentFileOffsets = this.segmentFileOffsets;
        if (offsetIndex >= (long)segmentFileOffsets.size()) {
            return MISSING_SEGMENT_FILE_OFFSET;
        }
        return segmentFileOffsets.get((int)offsetIndex);
    }

    long firstLogIndexInclusive() {
        return this.logIndexBase;
    }

    long lastLogIndexExclusive() {
        return this.logIndexBase + (long)this.segmentFileOffsets.size();
    }

    long firstIndexKept() {
        return this.firstIndexKept;
    }

    boolean isPrefixTombstone() {
        return this.logIndexBase == -1L;
    }

    int size() {
        return this.segmentFileOffsets.size();
    }

    void saveOffsetsTo(ByteBuffer buffer) {
        ArrayWithSize offsets = this.segmentFileOffsets;
        assert (offsets.size() > 0) : "Offsets array must not be empty";
        buffer.asIntBuffer().put(offsets.array, 0, offsets.size);
    }

    SegmentInfo truncateSuffix(long lastLogIndexKept) {
        assert (lastLogIndexKept >= this.logIndexBase) : String.format("logIndexBase=%d, lastLogIndexKept=%d", this.logIndexBase, lastLogIndexKept);
        ArrayWithSize segmentFileOffsets = this.segmentFileOffsets;
        long lastLogIndexExclusive = this.logIndexBase + (long)segmentFileOffsets.size();
        if (lastLogIndexKept >= lastLogIndexExclusive) {
            throw new IllegalArgumentException(String.format("lastLogIndexKept is too large. Last index in memtable: %d, lastLogIndexKept: %d", lastLogIndexExclusive - 1L, lastLogIndexKept));
        }
        int newSize = Math.toIntExact(lastLogIndexKept - this.logIndexBase + 1L);
        this.setSegmentFileOffsets(segmentFileOffsets, segmentFileOffsets.truncateSuffix(newSize));
        return this;
    }

    SegmentInfo truncatePrefix(long firstIndexKept) {
        if (this.isPrefixTombstone()) {
            if (firstIndexKept <= this.firstIndexKept) {
                throw new IllegalStateException(String.format("Trying to truncate an already truncated prefix [curFirstIndexKept=%d, newFirstIndexKept=%d]", this.firstIndexKept, firstIndexKept));
            }
            return SegmentInfo.prefixTombstone(firstIndexKept);
        }
        ArrayWithSize segmentFileOffsets = this.segmentFileOffsets;
        if (firstIndexKept < this.logIndexBase) {
            return new SegmentInfo(this.logIndexBase, firstIndexKept, segmentFileOffsets);
        }
        long lastLogIndexExclusive = this.logIndexBase + (long)segmentFileOffsets.size();
        if (firstIndexKept >= lastLogIndexExclusive) {
            throw new IllegalArgumentException(String.format("firstIndexKept is too large. Last index in memtable: %d, firstIndexKept: %d", lastLogIndexExclusive - 1L, firstIndexKept));
        }
        int newSize = Math.toIntExact(lastLogIndexExclusive - firstIndexKept);
        return new SegmentInfo(firstIndexKept, firstIndexKept, segmentFileOffsets.truncatePrefix(newSize));
    }

    SegmentInfo reset(long nextLogIndex) {
        assert (nextLogIndex > this.logIndexBase) : String.format("nextLogIndex=%d, logIndexBase=%d", nextLogIndex, this.logIndexBase);
        int nextOffsetIndex = Math.toIntExact(nextLogIndex - this.logIndexBase);
        int offsetToKeep = this.segmentFileOffsets.get(nextOffsetIndex);
        ArrayWithSize newSegmentFileOffsets = new ArrayWithSize().add(offsetToKeep);
        return new SegmentInfo(nextLogIndex, nextLogIndex, newSegmentFileOffsets);
    }

    private void setSegmentFileOffsets(ArrayWithSize segmentFileOffsets, ArrayWithSize newSegmentFileOffsets) {
        boolean updated = SEGMENT_FILE_OFFSETS_VH.compareAndSet(this, segmentFileOffsets, newSegmentFileOffsets);
        assert (updated) : "Concurrent writes detected";
    }

    static {
        try {
            SEGMENT_FILE_OFFSETS_VH = MethodHandles.lookup().findVarHandle(SegmentInfo.class, "segmentFileOffsets", ArrayWithSize.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ArrayWithSize {
        private static final int INITIAL_CAPACITY = 10;
        private final int[] array;
        private final int size;

        ArrayWithSize() {
            this(new int[10], 0);
        }

        private ArrayWithSize(int[] array, int size) {
            this.array = array;
            this.size = size;
        }

        ArrayWithSize add(int element) {
            int[] array = this.array;
            if (this.size == array.length) {
                array = Arrays.copyOf(array, array.length * 2);
            }
            array[this.size] = element;
            return new ArrayWithSize(array, this.size + 1);
        }

        ArrayWithSize truncateSuffix(int newSize) {
            return this.truncate(0, newSize);
        }

        ArrayWithSize truncatePrefix(int newSize) {
            int srcPos = this.size - newSize;
            return this.truncate(srcPos, newSize);
        }

        private ArrayWithSize truncate(int srcPos, int newSize) {
            assert (newSize <= this.size) : String.format("Array must shrink on truncation, current size: %d, size after truncation: %d", this.size, newSize);
            int[] newArray = new int[this.array.length];
            System.arraycopy(this.array, srcPos, newArray, 0, newSize);
            return new ArrayWithSize(newArray, newSize);
        }

        int get(int index) {
            return this.array[index];
        }

        int size() {
            return this.size;
        }
    }
}

