/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.raft.storage.segstore.MappedByteBufferSyncer;
import org.jetbrains.annotations.Nullable;

class SegmentFile
implements ManuallyCloseable {
    static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private static final int CLOSED_POS_MARKER = -1;
    private static final MappedByteBufferSyncer SYNCER = MappedByteBufferSyncer.createSyncer();
    private final MappedByteBuffer buffer;
    private final boolean isSync;
    private final AtomicInteger bufferPosition = new AtomicInteger();
    private final AtomicInteger numWriters = new AtomicInteger();
    private volatile int lastWritePosition;
    private volatile int syncPosition;
    private final Object syncLock = new Object();

    private SegmentFile(RandomAccessFile file, boolean isSync) throws IOException {
        this.buffer = file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, file.length());
        this.isSync = isSync;
    }

    static SegmentFile createNew(Path path, long fileSize, boolean isSync) throws IOException {
        if (fileSize < 0L) {
            throw new IllegalArgumentException("File size is negative: " + fileSize);
        }
        if (fileSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File size is too big: " + fileSize);
        }
        try (RandomAccessFile file = new RandomAccessFile(path.toFile(), "rw");){
            file.setLength(fileSize);
            SegmentFile segmentFile = new SegmentFile(file, isSync);
            return segmentFile;
        }
    }

    static SegmentFile openExisting(Path path, boolean isSync) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("File does not exist: " + path);
        }
        try (RandomAccessFile file = new RandomAccessFile(path.toFile(), "rw");){
            SegmentFile segmentFile = new SegmentFile(file, isSync);
            return segmentFile;
        }
    }

    ByteBuffer buffer() {
        return this.buffer.duplicate().order(BYTE_ORDER);
    }

    void closeForRollover(byte[] bytesToWrite) {
        this.close(bytesToWrite);
    }

    @Override
    public void close() {
        this.close(null);
    }

    private void close(byte @Nullable [] bytesToWrite) {
        int pos = this.bufferPosition.getAndSet(-1);
        if (pos == -1) {
            return;
        }
        while (this.numWriters.get() > 0) {
            Thread.onSpinWait();
        }
        if (bytesToWrite != null && pos + bytesToWrite.length <= this.buffer.limit()) {
            this.slice(pos, bytesToWrite.length).put(bytesToWrite);
            this.lastWritePosition = pos + bytesToWrite.length;
        } else {
            this.lastWritePosition = pos;
        }
    }

    @Nullable
    WriteBuffer reserve(int size) {
        this.numWriters.incrementAndGet();
        try {
            ByteBuffer slice = this.reserveBytes(size);
            if (slice == null) {
                this.numWriters.decrementAndGet();
                return null;
            }
            return new WriteBuffer(slice);
        }
        catch (Throwable e) {
            this.numWriters.decrementAndGet();
            throw e;
        }
    }

    int lastWritePosition() {
        return this.lastWritePosition;
    }

    int syncPosition() {
        return this.syncPosition;
    }

    void sync() {
        this.sync(this.lastWritePosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync(int upToPosition) {
        if (upToPosition <= this.syncPosition) {
            return;
        }
        Object object = this.syncLock;
        synchronized (object) {
            int syncPosition = this.syncPosition;
            if (upToPosition <= syncPosition) {
                return;
            }
            SYNCER.force(this.buffer, syncPosition, upToPosition - syncPosition);
            this.syncPosition = upToPosition;
        }
    }

    @Nullable
    private ByteBuffer reserveBytes(int size) {
        int nextPos;
        int pos;
        do {
            if ((pos = this.bufferPosition.get()) == -1) {
                return null;
            }
            nextPos = pos + size;
            if (nextPos <= this.buffer.limit()) continue;
            return null;
        } while (!this.bufferPosition.compareAndSet(pos, nextPos));
        return this.slice(pos, size);
    }

    private ByteBuffer slice(int pos, int size) {
        return this.buffer().position(pos).limit(pos + size);
    }

    class WriteBuffer
    implements AutoCloseable {
        private final ByteBuffer slice;
        private final int pos;

        WriteBuffer(ByteBuffer slice) {
            this.slice = slice;
            this.pos = slice.position();
        }

        ByteBuffer buffer() {
            return this.slice;
        }

        @Override
        public void close() {
            if (SegmentFile.this.isSync) {
                while (SegmentFile.this.lastWritePosition != this.pos) {
                    Thread.onSpinWait();
                }
                SegmentFile.this.lastWritePosition = this.slice.limit();
                SegmentFile.this.sync(this.slice.limit());
            }
            SegmentFile.this.numWriters.decrementAndGet();
        }
    }
}

