/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.io.FileDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.lang.ErrorGroups;

abstract class MappedByteBufferSyncer {
    MappedByteBufferSyncer() {
    }

    abstract void force(MappedByteBuffer var1, int var2, int var3);

    static MappedByteBufferSyncer createSyncer() {
        return IgniteUtils.majorJavaVersion(IgniteUtils.jdkVersion()) >= 13 ? new Jdk13Syncer() : new LegacySyncer();
    }

    private static Method findMethod(String name, Class<?> ... paramTypes) {
        try {
            Method mtd = MappedByteBuffer.class.getDeclaredMethod(name, paramTypes);
            mtd.setAccessible(true);
            return mtd;
        }
        catch (NoSuchMethodException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    }

    private static Field findField(String name) {
        try {
            Field field = MappedByteBuffer.class.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
        }
    }

    private static class Jdk13Syncer
    extends MappedByteBufferSyncer {
        private static final Method force = MappedByteBufferSyncer.findMethod("force", Integer.TYPE, Integer.TYPE);

        private Jdk13Syncer() {
        }

        @Override
        public void force(MappedByteBuffer buf, int index, int length) {
            try {
                force.invoke((Object)buf, index, length);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
            }
        }
    }

    private static class LegacySyncer
    extends MappedByteBufferSyncer {
        private static final Field fd = MappedByteBufferSyncer.findField("fd");
        private static final Method force0 = MappedByteBufferSyncer.findMethod("force0", FileDescriptor.class, Long.TYPE, Long.TYPE);
        private static final Method mappingOffset = MappedByteBufferSyncer.findMethod("mappingOffset", new Class[0]);
        private static final Method mappingAddress = MappedByteBufferSyncer.findMethod("mappingAddress", Long.TYPE);

        private LegacySyncer() {
        }

        @Override
        public void force(MappedByteBuffer buf, int index, int length) {
            try {
                long mappingOffset = (Long)LegacySyncer.mappingOffset.invoke((Object)buf, new Object[0]);
                assert (mappingOffset == 0L) : mappingOffset;
                long mappingAddress = (Long)LegacySyncer.mappingAddress.invoke((Object)buf, mappingOffset);
                long alignmentDelta = (mappingAddress + (long)index) % (long)GridUnsafe.pageSize();
                long alignedAddress = mappingAddress + (long)index - alignmentDelta;
                force0.invoke((Object)buf, fd.get(buf), alignedAddress, (long)length + alignmentDelta);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, (Throwable)e);
            }
        }
    }
}

