/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.raft.storage.segstore;

import java.util.Arrays;
import org.apache.ignite3.internal.raft.storage.segstore.IndexFileMeta;
import org.jetbrains.annotations.Nullable;

class IndexFileMetaArray {
    static final int INITIAL_CAPACITY = 10;
    private final IndexFileMeta[] array;
    private final int size;

    IndexFileMetaArray(IndexFileMeta initialMeta) {
        this.array = new IndexFileMeta[10];
        this.array[0] = initialMeta;
        this.size = 1;
    }

    private IndexFileMetaArray(IndexFileMeta[] array, int size) {
        this.array = array;
        this.size = size;
    }

    IndexFileMetaArray add(IndexFileMeta indexFileMeta) {
        assert (indexFileMeta.firstLogIndexInclusive() == this.array[this.size - 1].lastLogIndexExclusive()) : String.format("Index File Metas must be contiguous. Expected log index: %d, actual log index: %d", this.array[this.size - 1].lastLogIndexExclusive(), indexFileMeta.firstLogIndexInclusive());
        IndexFileMeta[] array = this.array;
        if (this.size == array.length) {
            array = Arrays.copyOf(array, array.length * 2);
        }
        array[this.size] = indexFileMeta;
        return new IndexFileMetaArray(array, this.size + 1);
    }

    IndexFileMeta get(int arrayIndex) {
        return this.array[arrayIndex];
    }

    int size() {
        return this.size;
    }

    long firstLogIndexInclusive() {
        IndexFileMeta firstMeta = this.array[0];
        IndexFileMeta lastMeta = this.array[this.size - 1];
        if (firstMeta.firstLogIndexInclusive() >= lastMeta.lastLogIndexExclusive()) {
            return -1L;
        }
        return firstMeta.firstLogIndexInclusive();
    }

    long lastLogIndexExclusive() {
        return this.array[this.size - 1].lastLogIndexExclusive();
    }

    @Nullable
    IndexFileMeta find(long logIndex) {
        int arrayIndex = this.findArrayIndex(logIndex);
        return arrayIndex == -1 ? null : this.array[arrayIndex];
    }

    private int findArrayIndex(long logIndex) {
        int lowArrayIndex = 0;
        int highArrayIndex = this.size - 1;
        while (lowArrayIndex <= highArrayIndex) {
            int middleArrayIndex = lowArrayIndex + highArrayIndex >>> 1;
            IndexFileMeta midValue = this.array[middleArrayIndex];
            if (logIndex < midValue.firstLogIndexInclusive()) {
                highArrayIndex = middleArrayIndex - 1;
                continue;
            }
            if (logIndex >= midValue.lastLogIndexExclusive()) {
                lowArrayIndex = middleArrayIndex + 1;
                continue;
            }
            return middleArrayIndex;
        }
        return -1;
    }

    IndexFileMetaArray truncateIndicesSmallerThan(long firstLogIndexKept) {
        int firstLogIndexKeptArrayIndex = this.findArrayIndex(firstLogIndexKept);
        assert (firstLogIndexKeptArrayIndex >= 0) : String.format("Missing entry for log index %d in range [%d:%d).", firstLogIndexKept, this.firstLogIndexInclusive(), this.lastLogIndexExclusive());
        IndexFileMeta metaToUpdate = this.array[firstLogIndexKeptArrayIndex];
        int numEntriesToSkip = Math.toIntExact(firstLogIndexKept - metaToUpdate.firstLogIndexInclusive());
        assert (numEntriesToSkip >= 0) : String.format("Trying to do a no-op prefix truncate from index %d in range [%d:%d).", firstLogIndexKept, this.firstLogIndexInclusive(), this.lastLogIndexExclusive());
        int adjustedPayloadOffset = metaToUpdate.indexFilePayloadOffset() + numEntriesToSkip * 4;
        IndexFileMeta trimmedMeta = new IndexFileMeta(firstLogIndexKept, metaToUpdate.lastLogIndexExclusive(), adjustedPayloadOffset, metaToUpdate.indexFileOrdinal());
        IndexFileMeta[] newArray = new IndexFileMeta[this.array.length];
        newArray[0] = trimmedMeta;
        int newSize = this.size - firstLogIndexKeptArrayIndex;
        if (newSize > 1) {
            System.arraycopy(this.array, firstLogIndexKeptArrayIndex + 1, newArray, 1, newSize - 1);
        }
        return new IndexFileMetaArray(newArray, newSize);
    }
}

