/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft.snapshot;

import java.util.Objects;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.tostring.S;

public class PartitionKey {
    private final int zoneId;
    private final int partitionId;

    public PartitionKey(int zoneId, int partitionId) {
        this.zoneId = zoneId;
        this.partitionId = partitionId;
    }

    public int zoneId() {
        return this.zoneId;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionKey that = (PartitionKey)o;
        return this.partitionId == that.partitionId && this.zoneId == that.zoneId;
    }

    public int hashCode() {
        return Objects.hash(this.zoneId, this.partitionId);
    }

    public String toString() {
        return S.toString(PartitionKey.class, this);
    }

    public ZonePartitionId toReplicationGroupId() {
        return new ZonePartitionId(this.zoneId, this.partitionId);
    }
}

