/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.partition.replicator.network.replication.BinaryRowWithTombstoneMessage;
import org.apache.ignite3.internal.partition.replicator.network.replication.TransferRowVersionsToSecondaryReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.TransferRowVersionsToSecondaryReplicaRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.TransferRowVersionsToSecondaryReplicaRequestSerializer;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tostring.IgniteStringifier;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tostring.SizeOnlyStringifier;

public class TransferRowVersionsToSecondaryReplicaRequestImpl
implements TransferRowVersionsToSecondaryReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 16372;
    @IgniteToStringInclude
    private final Long enlistmentConsistencyToken;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteStringifier(name="rows.size", value=SizeOnlyStringifier.class)
    private final List<BinaryRowWithTombstoneMessage> rows;
    @IgniteToStringInclude
    private final int tableId;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;

    private TransferRowVersionsToSecondaryReplicaRequestImpl(Long enlistmentConsistencyToken, ReplicationGroupIdMessage groupId, List<BinaryRowWithTombstoneMessage> rows, int tableId, HybridTimestamp timestamp) {
        this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        this.groupId = groupId;
        this.rows = rows;
        this.tableId = tableId;
        this.timestamp = timestamp;
    }

    @Override
    public Long enlistmentConsistencyToken() {
        return this.enlistmentConsistencyToken;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public List<BinaryRowWithTombstoneMessage> rows() {
        return this.rows;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public MessageSerializer serializer() {
        return TransferRowVersionsToSecondaryReplicaRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(TransferRowVersionsToSecondaryReplicaRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 16372;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransferRowVersionsToSecondaryReplicaRequestImpl otherMessage = (TransferRowVersionsToSecondaryReplicaRequestImpl)other;
        return Objects.equals(this.enlistmentConsistencyToken, otherMessage.enlistmentConsistencyToken) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.rows, otherMessage.rows) && Objects.equals(this.timestamp, otherMessage.timestamp) && this.tableId == otherMessage.tableId;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.tableId, this.enlistmentConsistencyToken, this.groupId, this.rows, this.timestamp);
        return result;
    }

    @Override
    public TransferRowVersionsToSecondaryReplicaRequestImpl clone() {
        try {
            return (TransferRowVersionsToSecondaryReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TransferRowVersionsToSecondaryReplicaRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
        if (this.rows != null) {
            for (BinaryRowWithTombstoneMessage obj : this.rows) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
        if (this.rows != null) {
            for (BinaryRowWithTombstoneMessage obj : this.rows) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements TransferRowVersionsToSecondaryReplicaRequestBuilder {
        private Long enlistmentConsistencyToken;
        private ReplicationGroupIdMessage groupId;
        private List<BinaryRowWithTombstoneMessage> rows;
        private int tableId;
        private HybridTimestamp timestamp;

        private Builder() {
        }

        @Override
        public TransferRowVersionsToSecondaryReplicaRequestBuilder enlistmentConsistencyToken(Long enlistmentConsistencyToken) {
            Objects.requireNonNull(enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable");
            this.enlistmentConsistencyToken = enlistmentConsistencyToken;
            return this;
        }

        @Override
        public TransferRowVersionsToSecondaryReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public TransferRowVersionsToSecondaryReplicaRequestBuilder rows(List<BinaryRowWithTombstoneMessage> rows) {
            Objects.requireNonNull(rows, "rows is not marked @Nullable");
            this.rows = rows;
            return this;
        }

        @Override
        public TransferRowVersionsToSecondaryReplicaRequestBuilder tableId(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public TransferRowVersionsToSecondaryReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public Long enlistmentConsistencyToken() {
            return this.enlistmentConsistencyToken;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public List<BinaryRowWithTombstoneMessage> rows() {
            return this.rows;
        }

        @Override
        public int tableId() {
            return this.tableId;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public TransferRowVersionsToSecondaryReplicaRequest build() {
            return new TransferRowVersionsToSecondaryReplicaRequestImpl(Objects.requireNonNull(this.enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable"), Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.rows, "rows is not marked @Nullable"), this.tableId, this.timestamp);
        }

        @Override
        public TransferRowVersionsToSecondaryReplicaRequest buildDeserialized() {
            return new TransferRowVersionsToSecondaryReplicaRequestImpl(this.enlistmentConsistencyToken, this.groupId, this.rows, this.tableId, this.timestamp);
        }
    }
}

