/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesTypeInfos;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteSwapRowReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadWriteSwapRowReplicaRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.replicator.message.ZonePartitionIdMessage;

class ReadWriteSwapRowReplicaRequestDeserializer
implements MessageDeserializer<ReadWriteSwapRowReplicaRequest> {
    private final ReadWriteSwapRowReplicaRequestBuilder msg;

    ReadWriteSwapRowReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readWriteSwapRowReplicaRequest();
    }

    @Override
    public Class<ReadWriteSwapRowReplicaRequest> klass() {
        return ReadWriteSwapRowReplicaRequest.class;
    }

    @Override
    public ReadWriteSwapRowReplicaRequest getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(PartitionReplicationMessagesTypeInfos.readWriteSwapRowReplicaRequest());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = (ZonePartitionIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitPartitionId((ZonePartitionIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readUuid("coordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.coordinatorId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.enlistmentConsistencyToken((Long)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.groupId((ReplicationGroupIdMessage)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readByteBuffer("newBinaryTuple");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.newBinaryTuple((ByteBuffer)tmp);
                }
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readByteBuffer("oldBinaryTuple");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.oldBinaryTuple((ByteBuffer)tmp);
                }
                reader.incrementState();
            }
            case 7: {
                RequestType tmp;
                int shiftedId = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType requestType = tmp = shiftedId == 0 ? null : RequestType.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.requestType(tmp);
                }
                reader.incrementState();
            }
            case 8: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
            case 9: {
                int tmp = reader.readBoolean("skipDelayedAck") ? 1 : 0;
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.skipDelayedAck(tmp != 0);
                reader.incrementState();
            }
            case 10: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 11: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 12: {
                Object tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.transactionId((UUID)tmp);
                }
                reader.incrementState();
            }
            case 13: {
                Object tmp = reader.readString("txLabel");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txLabel((String)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadWriteSwapRowReplicaRequest.class);
    }
}

